package com.mypurecloud.sdk.v2.api.request;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.ApiResponse;
import com.mypurecloud.sdk.v2.Configuration;
import com.mypurecloud.sdk.v2.model.*;
import com.mypurecloud.sdk.v2.Pair;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

import com.mypurecloud.sdk.v2.model.ErrorBody;
import com.mypurecloud.sdk.v2.model.Operation;
import com.mypurecloud.sdk.v2.model.DependencyObjectEntityListing;
import com.mypurecloud.sdk.v2.model.DependencyStatus;
import com.mypurecloud.sdk.v2.model.ConsumedResourcesEntityListing;
import com.mypurecloud.sdk.v2.model.ConsumingResourcesEntityListing;
import com.mypurecloud.sdk.v2.model.DependencyObject;
import com.mypurecloud.sdk.v2.model.DependencyType;
import com.mypurecloud.sdk.v2.model.DependencyTypeEntityListing;
import com.mypurecloud.sdk.v2.model.EmergencyGroup;
import com.mypurecloud.sdk.v2.model.EmergencyGroupListing;
import com.mypurecloud.sdk.v2.model.IVR;
import com.mypurecloud.sdk.v2.model.IVREntityListing;
import com.mypurecloud.sdk.v2.model.Prompt;
import com.mypurecloud.sdk.v2.model.HistoryListing;
import com.mypurecloud.sdk.v2.model.PromptAsset;
import com.mypurecloud.sdk.v2.model.PromptAssetEntityListing;
import com.mypurecloud.sdk.v2.model.PromptEntityListing;
import com.mypurecloud.sdk.v2.model.Schedule;
import com.mypurecloud.sdk.v2.model.ScheduleGroup;
import com.mypurecloud.sdk.v2.model.ScheduleGroupEntityListing;
import com.mypurecloud.sdk.v2.model.ScheduleEntityListing;
import com.mypurecloud.sdk.v2.model.SystemPrompt;
import com.mypurecloud.sdk.v2.model.SystemPromptAsset;
import com.mypurecloud.sdk.v2.model.SystemPromptAssetEntityListing;
import com.mypurecloud.sdk.v2.model.SystemPromptEntityListing;
import com.mypurecloud.sdk.v2.model.Flow;
import com.mypurecloud.sdk.v2.model.FlowVersion;
import com.mypurecloud.sdk.v2.model.FlowVersionEntityListing;
import com.mypurecloud.sdk.v2.model.FlowEntityListing;
import com.mypurecloud.sdk.v2.model.DataTable;
import com.mypurecloud.sdk.v2.model.DataTableRowEntityListing;
import com.mypurecloud.sdk.v2.model.DataTablesDomainEntityListing;
import com.mypurecloud.sdk.v2.model.FlowDivisionViewEntityListing;
import com.mypurecloud.sdk.v2.model.PromptAssetCreate;

public class PutArchitectEmergencygroupRequest {
    
	private String emergencyGroupId;
	public String getEmergencyGroupId() {
		return this.emergencyGroupId;
	}

	public void setEmergencyGroupId(String emergencyGroupId) {
		this.emergencyGroupId = emergencyGroupId;
	}

	public PutArchitectEmergencygroupRequest withEmergencyGroupId(String emergencyGroupId) {
	    this.setEmergencyGroupId(emergencyGroupId);
	    return this;
	} 
	
	private EmergencyGroup body;
	public EmergencyGroup getBody() {
		return this.body;
	}

	public void setBody(EmergencyGroup body) {
		this.body = body;
	}

	public PutArchitectEmergencygroupRequest withBody(EmergencyGroup body) {
	    this.setBody(body);
	    return this;
	} 
	
	private final Map<String, String> customHeaders = new HashMap<>();
    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PutArchitectEmergencygroupRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<EmergencyGroup> withHttpInfo() {
        
        // verify the required parameter 'emergencyGroupId' is set
        if (this.emergencyGroupId == null) {
            throw new IllegalStateException("Missing the required parameter 'emergencyGroupId' when building request for PutArchitectEmergencygroupRequest.");
        }
        
        // verify the required parameter 'body' is set
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PutArchitectEmergencygroupRequest.");
        }
        

        return ApiRequestBuilder.create("PUT", "/api/v2/architect/emergencygroups/{emergencyGroupId}")
                .withPathParameter("emergencyGroupId", emergencyGroupId)
        
                .withBody(body)
        
                .withCustomHeaders(customHeaders)
                .withContentTypes("application/json")
                .withAccepts("application/json")
                .withAuthNames("PureCloud Auth")
                .build();
    }

	public static Builder builder() {
		return new Builder();
	}

	
	public static Builder builder(String emergencyGroupId, EmergencyGroup body) {
	    return new Builder()
	            .withRequiredParams(emergencyGroupId, body);
	}
	

	public static class Builder {
		private final PutArchitectEmergencygroupRequest request;

		private Builder() {
			request = new PutArchitectEmergencygroupRequest();
		}

		
		public Builder withEmergencyGroupId(String emergencyGroupId) {
			request.setEmergencyGroupId(emergencyGroupId);
			return this;
		}
		
		public Builder withBody(EmergencyGroup body) {
			request.setBody(body);
			return this;
		}
		

		
		public Builder withRequiredParams(String emergencyGroupId, EmergencyGroup body) {
			request.setEmergencyGroupId(emergencyGroupId);
						request.setBody(body);
			
			return this;
		}
		

		public PutArchitectEmergencygroupRequest build() {
            
            // verify the required parameter 'emergencyGroupId' is set
            if (request.emergencyGroupId == null) {
                throw new IllegalStateException("Missing the required parameter 'emergencyGroupId' when building request for PutArchitectEmergencygroupRequest.");
            }
            
            // verify the required parameter 'body' is set
            if (request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PutArchitectEmergencygroupRequest.");
            }
            
			return request;
		}
	}
}
