package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
/**
 * ChangeMyPasswordRequest
 */

public class ChangeMyPasswordRequest  implements Serializable {
  
  private String newPassword = null;
  private String oldPassword = null;

  
  /**
   * The new password
   **/
  public ChangeMyPasswordRequest newPassword(String newPassword) {
    this.newPassword = newPassword;
    return this;
  }
  
  @ApiModelProperty(example = "null", required = true, value = "The new password")
  @JsonProperty("newPassword")
  public String getNewPassword() {
    return newPassword;
  }
  public void setNewPassword(String newPassword) {
    this.newPassword = newPassword;
  }

  
  /**
   * Your current password
   **/
  public ChangeMyPasswordRequest oldPassword(String oldPassword) {
    this.oldPassword = oldPassword;
    return this;
  }
  
  @ApiModelProperty(example = "null", required = true, value = "Your current password")
  @JsonProperty("oldPassword")
  public String getOldPassword() {
    return oldPassword;
  }
  public void setOldPassword(String oldPassword) {
    this.oldPassword = oldPassword;
  }

  

  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ChangeMyPasswordRequest changeMyPasswordRequest = (ChangeMyPasswordRequest) o;
    return Objects.equals(this.newPassword, changeMyPasswordRequest.newPassword) &&
        Objects.equals(this.oldPassword, changeMyPasswordRequest.oldPassword);
  }

  @Override
  public int hashCode() {
    return Objects.hash(newPassword, oldPassword);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ChangeMyPasswordRequest {\n");
    
    sb.append("    newPassword: ").append(toIndentedString(newPassword)).append("\n");
    sb.append("    oldPassword: ").append(toIndentedString(oldPassword)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

