package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.JsonSchemaDocument;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
/**
 * Contains a metadata representation for a JSON schema stored in DataTables along with an optional field for the schema itself
 */
@ApiModel(description = "Contains a metadata representation for a JSON schema stored in DataTables along with an optional field for the schema itself")

public class DataTable  implements Serializable {
  
  private String id = null;
  private String name = null;
  private String description = null;
  private JsonSchemaDocument schema = null;
  private String selfUri = null;

  
  @ApiModelProperty(example = "null", value = "The globally unique identifier for the object.")
  @JsonProperty("id")
  public String getId() {
    return id;
  }

  
  /**
   **/
  public DataTable name(String name) {
    this.name = name;
    return this;
  }
  
  @ApiModelProperty(example = "null", value = "")
  @JsonProperty("name")
  public String getName() {
    return name;
  }
  public void setName(String name) {
    this.name = name;
  }

  
  /**
   * The description from the JSON schema (equates to the Description field on the JSON schema.)
   **/
  public DataTable description(String description) {
    this.description = description;
    return this;
  }
  
  @ApiModelProperty(example = "null", value = "The description from the JSON schema (equates to the Description field on the JSON schema.)")
  @JsonProperty("description")
  public String getDescription() {
    return description;
  }
  public void setDescription(String description) {
    this.description = description;
  }

  
  /**
   * the schema as stored in the system.
   **/
  public DataTable schema(JsonSchemaDocument schema) {
    this.schema = schema;
    return this;
  }
  
  @ApiModelProperty(example = "null", value = "the schema as stored in the system.")
  @JsonProperty("schema")
  public JsonSchemaDocument getSchema() {
    return schema;
  }
  public void setSchema(JsonSchemaDocument schema) {
    this.schema = schema;
  }

  
  @ApiModelProperty(example = "null", value = "The URI for this object")
  @JsonProperty("selfUri")
  public String getSelfUri() {
    return selfUri;
  }

  

  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DataTable dataTable = (DataTable) o;
    return Objects.equals(this.id, dataTable.id) &&
        Objects.equals(this.name, dataTable.name) &&
        Objects.equals(this.description, dataTable.description) &&
        Objects.equals(this.schema, dataTable.schema) &&
        Objects.equals(this.selfUri, dataTable.selfUri);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, name, description, schema, selfUri);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DataTable {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    schema: ").append(toIndentedString(schema)).append("\n");
    sb.append("    selfUri: ").append(toIndentedString(selfUri)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

