package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
/**
 * DependencyType
 */

public class DependencyType  implements Serializable {
  
  private String id = null;
  private String name = null;
  private Boolean versioned = null;
  private String selfUri = null;

  
  @ApiModelProperty(example = "null", value = "The globally unique identifier for the object.")
  @JsonProperty("id")
  public String getId() {
    return id;
  }

  
  /**
   **/
  public DependencyType name(String name) {
    this.name = name;
    return this;
  }
  
  @ApiModelProperty(example = "null", value = "")
  @JsonProperty("name")
  public String getName() {
    return name;
  }
  public void setName(String name) {
    this.name = name;
  }

  
  /**
   **/
  public DependencyType versioned(Boolean versioned) {
    this.versioned = versioned;
    return this;
  }
  
  @ApiModelProperty(example = "null", value = "")
  @JsonProperty("versioned")
  public Boolean getVersioned() {
    return versioned;
  }
  public void setVersioned(Boolean versioned) {
    this.versioned = versioned;
  }

  
  @ApiModelProperty(example = "null", value = "The URI for this object")
  @JsonProperty("selfUri")
  public String getSelfUri() {
    return selfUri;
  }

  

  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DependencyType dependencyType = (DependencyType) o;
    return Objects.equals(this.id, dependencyType.id) &&
        Objects.equals(this.name, dependencyType.name) &&
        Objects.equals(this.versioned, dependencyType.versioned) &&
        Objects.equals(this.selfUri, dependencyType.selfUri);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, name, versioned, selfUri);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DependencyType {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    versioned: ").append(toIndentedString(versioned)).append("\n");
    sb.append("    selfUri: ").append(toIndentedString(selfUri)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

