package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;

import java.io.Serializable;
/**
 * EdgeLogsJobUploadRequest
 */

public class EdgeLogsJobUploadRequest  implements Serializable {
  
  private List<String> fileIds = new ArrayList<String>();

  
  /**
   * A list of file ids to upload.
   **/
  public EdgeLogsJobUploadRequest fileIds(List<String> fileIds) {
    this.fileIds = fileIds;
    return this;
  }
  
  @ApiModelProperty(example = "null", required = true, value = "A list of file ids to upload.")
  @JsonProperty("fileIds")
  public List<String> getFileIds() {
    return fileIds;
  }
  public void setFileIds(List<String> fileIds) {
    this.fileIds = fileIds;
  }

  

  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    EdgeLogsJobUploadRequest edgeLogsJobUploadRequest = (EdgeLogsJobUploadRequest) o;
    return Objects.equals(this.fileIds, edgeLogsJobUploadRequest.fileIds);
  }

  @Override
  public int hashCode() {
    return Objects.hash(fileIds);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class EdgeLogsJobUploadRequest {\n");
    
    sb.append("    fileIds: ").append(toIndentedString(fileIds)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

