package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.LicenseDefinition;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;

import java.io.Serializable;
/**
 * LicenseUser
 */

public class LicenseUser  implements Serializable {
  
  private String id = null;
  private List<LicenseDefinition> licenses = new ArrayList<LicenseDefinition>();
  private String selfUri = null;

  
  @ApiModelProperty(example = "null", value = "The globally unique identifier for the object.")
  @JsonProperty("id")
  public String getId() {
    return id;
  }

  
  /**
   **/
  public LicenseUser licenses(List<LicenseDefinition> licenses) {
    this.licenses = licenses;
    return this;
  }
  
  @ApiModelProperty(example = "null", value = "")
  @JsonProperty("licenses")
  public List<LicenseDefinition> getLicenses() {
    return licenses;
  }
  public void setLicenses(List<LicenseDefinition> licenses) {
    this.licenses = licenses;
  }

  
  @ApiModelProperty(example = "null", value = "The URI for this object")
  @JsonProperty("selfUri")
  public String getSelfUri() {
    return selfUri;
  }

  

  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    LicenseUser licenseUser = (LicenseUser) o;
    return Objects.equals(this.id, licenseUser.id) &&
        Objects.equals(this.licenses, licenseUser.licenses) &&
        Objects.equals(this.selfUri, licenseUser.selfUri);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, licenses, selfUri);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class LicenseUser {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    licenses: ").append(toIndentedString(licenses)).append("\n");
    sb.append("    selfUri: ").append(toIndentedString(selfUri)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

