package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.LocalEncryptionConfiguration;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;

import java.io.Serializable;
/**
 * LocalEncryptionConfigurationListing
 */

public class LocalEncryptionConfigurationListing  implements Serializable {
  
  private Long total = null;
  private List<LocalEncryptionConfiguration> entities = new ArrayList<LocalEncryptionConfiguration>();
  private String selfUri = null;

  
  /**
   **/
  public LocalEncryptionConfigurationListing total(Long total) {
    this.total = total;
    return this;
  }
  
  @ApiModelProperty(example = "null", value = "")
  @JsonProperty("total")
  public Long getTotal() {
    return total;
  }
  public void setTotal(Long total) {
    this.total = total;
  }

  
  /**
   **/
  public LocalEncryptionConfigurationListing entities(List<LocalEncryptionConfiguration> entities) {
    this.entities = entities;
    return this;
  }
  
  @ApiModelProperty(example = "null", value = "")
  @JsonProperty("entities")
  public List<LocalEncryptionConfiguration> getEntities() {
    return entities;
  }
  public void setEntities(List<LocalEncryptionConfiguration> entities) {
    this.entities = entities;
  }

  
  /**
   **/
  public LocalEncryptionConfigurationListing selfUri(String selfUri) {
    this.selfUri = selfUri;
    return this;
  }
  
  @ApiModelProperty(example = "null", value = "")
  @JsonProperty("selfUri")
  public String getSelfUri() {
    return selfUri;
  }
  public void setSelfUri(String selfUri) {
    this.selfUri = selfUri;
  }

  

  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    LocalEncryptionConfigurationListing localEncryptionConfigurationListing = (LocalEncryptionConfigurationListing) o;
    return Objects.equals(this.total, localEncryptionConfigurationListing.total) &&
        Objects.equals(this.entities, localEncryptionConfigurationListing.entities) &&
        Objects.equals(this.selfUri, localEncryptionConfigurationListing.selfUri);
  }

  @Override
  public int hashCode() {
    return Objects.hash(total, entities, selfUri);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class LocalEncryptionConfigurationListing {\n");
    
    sb.append("    total: ").append(toIndentedString(total)).append("\n");
    sb.append("    entities: ").append(toIndentedString(entities)).append("\n");
    sb.append("    selfUri: ").append(toIndentedString(selfUri)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

