/*
 * Copyright (c) 2009 Mysema Ltd.
 * All rights reserved.
 * 
 */
package com.mysema.commons.l10n;

import java.util.Locale;

/**
 * CustomLocaleState represents a custom search path
 * 
 * @author Samppa Saarela
 * @version $Id: CustomLocaleState.java 2401 2007-02-25 09:59:07Z tiwe $
 */
public final class CustomLocaleState implements State {

    private String language;

    private String country;

    private String variant;

    public CustomLocaleState(Locale locale) {
        language = locale.getLanguage();
        country = locale.getCountry();
        variant = locale.getVariant();
    }

    /**
     * @see com.mysema.commons.l10n.State#apply(java.util.Locale,
     *      java.lang.StringBuilder)
     */
    public boolean apply(Locale locale, StringBuilder baseName) {
        boolean l = language.length() != 0;
        boolean c = country.length() != 0;
        boolean v = variant.length() != 0;

        if (l || c || v) {
            baseName.append('_').append(language); // This may just append '_'
            if (c || v) {
                baseName.append('_').append(country); // This may just append
                                                      // '_'
            }
            if (v) {
                baseName.append('_').append(variant);
            }
        }

        return true;
    }

    /**
     * @see com.mysema.commons.l10n.State#convert(java.util.Locale)
     */
    public Locale convert(Locale locale) {
        return new Locale(language, country, variant);
    }

    /**
     * @see com.mysema.commons.l10n.State#filter(java.util.Locale)
     */
    public Locale filter(Locale locale) {
        return new Locale(language, country, variant);
    }

}
