/*
 * Copyright (c) 2009 Mysema Ltd.
 * All rights reserved.
 * 
 */
package com.mysema.commons.l10n;

import java.util.Locale;

/**
 * A State is one node in a resource search path.
 * 
 * @author Samppa Saarela
 * @version $Id: State.java 2401 2007-02-25 09:59:07Z tiwe $
 */
public interface State {

    /**
     * Apply this state to the baseName, i.e. modify the baseName so that it
     * corresponds to the name of this state. Return true if state is applicable
     * to the given locale. For example a state for language/country would
     * return for base name baseName.properties and locale fi_FI_Mac
     * baseName_fi_FI.properties/true, but for locale fi false.
     * 
     * @param locale
     *            the locale to apply on baseName according to this search path
     *            state.
     * @param baseName
     *            baseName of resource excluding extension.
     * @return true if this state is applicable to given locale.
     */
    boolean apply(Locale locale, StringBuilder baseName);

    /**
     * Convert offers the state a chance to change the locale to be searched
     * against. For example the search might start with locale fi_FI advancing
     * thourgh fi and the changing to default locale en_EN and continuing
     * through en and bare baseName. In most cases this method should just
     * return the locale given.
     * 
     * @param locale
     * @return
     */
    Locale convert(Locale locale);

    /**
     * Filter returns the effect of this state as locale. This offers the user a
     * chance to inspect what is the actual expected language of the resource
     * denoted by applying this state. In comparison to convert, the result of
     * this method doesn't modify the actual search path in any way.
     * 
     * @param locale
     * @return
     */
    Locale filter(Locale locale);

}
