/*
 * Copyright (c) 2009 Mysema Ltd.
 * All rights reserved.
 * 
 */
package com.mysema.commons.l10n;

import java.util.Locale;

/**
 * States groups various State implementations
 * 
 * @author Samppa Saarela
 * @version $Id: States.java 2785 2007-10-23 16:17:35Z tiwe $
 */
public enum States implements State {

    LCV {
        public boolean apply(Locale l, StringBuilder baseName) {
            if (isBlank(l.getLanguage())
                    || isBlank(l.getCountry())
                    || isBlank(l.getVariant())) {
                return false;
            }
            baseName.append("_").append(l.getLanguage()).append("_").append(
                    l.getCountry()).append("_").append(l.getVariant());
            return true;
        }
    },

    LV {
        public boolean apply(Locale l, StringBuilder baseName) {
            if (isBlank(l.getLanguage())
                    || isBlank(l.getVariant())) {
                return false;
            }
            baseName.append("_").append(l.getLanguage()).append("__").append(
                    l.getVariant());
            return true;
        }
    },

    V {
        public boolean apply(Locale l, StringBuilder baseName) {
            if (isBlank(l.getVariant())) {
                return false;
            }
            baseName.append("___").append(l.getVariant());
            return true;
        }
    },

    LC {
        public boolean apply(Locale l, StringBuilder baseName) {
            if (isBlank(l.getLanguage())
                    || isBlank(l.getCountry())) {
                return false;
            }
            baseName.append("_").append(l.getLanguage()).append("_").append(
                    l.getCountry());
            return true;
        }
    },

    L {
        public boolean apply(Locale l, StringBuilder baseName) {
            if (isBlank(l.getLanguage())) {
                return false;
            }
            baseName.append("_").append(l.getLanguage());
            return true;
        }
    },

    C {
        public boolean apply(Locale l, StringBuilder baseName) {
            if (isBlank(l.getCountry())) {
                return false;
            }
            baseName.append("__").append(l.getCountry());
            return true;
        }
    },

    DEFAULT {
        public boolean apply(Locale l, StringBuilder baseName) {
            return false;
        }

        public Locale convert(Locale l) {
            return Locale.getDefault();
        }

        public Locale filter(Locale l) {
            return Locale.getDefault();
        }
    },

    BARE {
        public boolean apply(Locale l, StringBuilder baseName) {
            return true;
        }

        public Locale filter(Locale l) {
            return new Locale("");
        }
    };
    
    private static boolean isBlank(String str) {
        return str == null || str.trim().isEmpty();
    }

    public abstract boolean apply(Locale l, StringBuilder baseName);

    public Locale convert(Locale l) {
        return l;
    }

    public Locale filter(Locale l) {
        String def = toString();
        if (def.length() < 4) {
            return new Locale(def.indexOf('L') >= 0 ? l.getLanguage() : "", def
                    .indexOf('C') >= 0 ? l.getCountry() : "",
                    def.indexOf('V') >= 0 ? l.getVariant() : "");
        } else {
            return null;
        }
    }

}
