/*
 * Copyright (c) 2009 Mysema Ltd.
 * All rights reserved.
 * 
 */
package com.mysema.commons.l10n.support;

import java.util.Iterator;
import java.util.Locale;

/**
 * LocaleIterable provides Iterators for locales based on a given one
 * 
 * @author Timo Westk&auml;mper
 * @version $Id: LocaleIterable.java 2401 2007-02-25 09:59:07Z tiwe $
 */
public class LocaleIterable implements Iterable<Locale> {

    private Locale locale;

    private boolean incDefault;

    /**
     * @param locale
     * @param incDefault
     */
    public LocaleIterable(Locale locale, boolean incDefault) {
        this.locale = locale;
        this.incDefault = incDefault;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Iterable#iterator()
     */
    public Iterator<Locale> iterator() {
        return new LocaleIterator(locale, incDefault);
    }

}
