/*
 * Copyright (c) 2009 Mysema Ltd.
 * All rights reserved.
 * 
 */
package com.mysema.commons.l10n.support;

import java.util.Iterator;
import java.util.Locale;

/**
 * LocalizedNameIterable provides Iterable based access to the
 * LocalizedNameIterator
 * 
 * @author Timo Westk&auml;mper
 * @version $Id: LocalizedNameIterable.java 2386 2007-02-24 18:04:04Z tiwe $
 */
public class LocalizedNames implements Iterable<String> {

    private String baseName;

    private Locale locale;

    private String suffix;

    /**
     * @param baseName
     * @param locale
     * @param suffix
     */
    public LocalizedNames(String baseName, Locale locale, String suffix) {
        this.baseName = baseName;
        this.locale = locale;
        this.suffix = suffix;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Iterable#iterator()
     */
    public Iterator<String> iterator() {
        return new LocalizedNameIterator(baseName, locale, suffix);
    }

}
