/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.commons.l10n;

import com.mysema.commons.l10n.State;
import java.util.Locale;

public final class CustomLocaleState
implements State {
    private String language;
    private String country;
    private String variant;

    public CustomLocaleState(Locale locale) {
        this.language = locale.getLanguage();
        this.country = locale.getCountry();
        this.variant = locale.getVariant();
    }

    public boolean apply(Locale locale, StringBuilder baseName) {
        boolean v;
        boolean l = this.language.length() != 0;
        boolean c = this.country.length() != 0;
        boolean bl = v = this.variant.length() != 0;
        if (l || c || v) {
            baseName.append('_').append(this.language);
            if (c || v) {
                baseName.append('_').append(this.country);
            }
            if (v) {
                baseName.append('_').append(this.variant);
            }
        }
        return true;
    }

    public Locale convert(Locale locale) {
        return new Locale(this.language, this.country, this.variant);
    }

    public Locale filter(Locale locale) {
        return new Locale(this.language, this.country, this.variant);
    }
}

