/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.commons.l10n;

import com.mysema.commons.l10n.State;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum States implements State
{
    LCV{

        public boolean apply(Locale l, StringBuilder baseName) {
            if (States.isBlank(l.getLanguage()) || States.isBlank(l.getCountry()) || States.isBlank(l.getVariant())) {
                return false;
            }
            baseName.append("_").append(l.getLanguage()).append("_").append(l.getCountry()).append("_").append(l.getVariant());
            return true;
        }
    }
    ,
    LV{

        public boolean apply(Locale l, StringBuilder baseName) {
            if (States.isBlank(l.getLanguage()) || States.isBlank(l.getVariant())) {
                return false;
            }
            baseName.append("_").append(l.getLanguage()).append("__").append(l.getVariant());
            return true;
        }
    }
    ,
    V{

        public boolean apply(Locale l, StringBuilder baseName) {
            if (States.isBlank(l.getVariant())) {
                return false;
            }
            baseName.append("___").append(l.getVariant());
            return true;
        }
    }
    ,
    LC{

        public boolean apply(Locale l, StringBuilder baseName) {
            if (States.isBlank(l.getLanguage()) || States.isBlank(l.getCountry())) {
                return false;
            }
            baseName.append("_").append(l.getLanguage()).append("_").append(l.getCountry());
            return true;
        }
    }
    ,
    L{

        public boolean apply(Locale l, StringBuilder baseName) {
            if (States.isBlank(l.getLanguage())) {
                return false;
            }
            baseName.append("_").append(l.getLanguage());
            return true;
        }
    }
    ,
    C{

        public boolean apply(Locale l, StringBuilder baseName) {
            if (States.isBlank(l.getCountry())) {
                return false;
            }
            baseName.append("__").append(l.getCountry());
            return true;
        }
    }
    ,
    DEFAULT{

        public boolean apply(Locale l, StringBuilder baseName) {
            return false;
        }

        public Locale convert(Locale l) {
            return Locale.getDefault();
        }

        public Locale filter(Locale l) {
            return Locale.getDefault();
        }
    }
    ,
    BARE{

        public boolean apply(Locale l, StringBuilder baseName) {
            return true;
        }

        public Locale filter(Locale l) {
            return new Locale("");
        }
    };


    private static boolean isBlank(String str) {
        return str == null || str.trim().isEmpty();
    }

    @Override
    public abstract boolean apply(Locale var1, StringBuilder var2);

    @Override
    public Locale convert(Locale l) {
        return l;
    }

    @Override
    public Locale filter(Locale l) {
        String def = this.toString();
        if (def.length() < 4) {
            return new Locale(def.indexOf(76) >= 0 ? l.getLanguage() : "", def.indexOf(67) >= 0 ? l.getCountry() : "", def.indexOf(86) >= 0 ? l.getVariant() : "");
        }
        return null;
    }
}

