/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.commons.l10n.support;

import com.mysema.commons.l10n.support.LocaleUtil;
import java.util.Iterator;
import java.util.Locale;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LocaleIterator
implements Iterator<Locale> {
    private static final int END = -1;
    private static final int B = 0;
    private static final int BL = 1;
    private static final int B_C = 2;
    private static final int BLC = 3;
    private static final int BL_V = 5;
    private static final int B_CV = 6;
    private static final int BLCV = 7;
    private Locale next;
    private boolean incDefault;
    private int stage;

    public LocaleIterator(Locale locale, boolean incDefault) {
        this.next = locale;
        this.incDefault = incDefault;
        this.stage = this.getLocaleStage(this.next);
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    public int getLocaleStage(Locale locale) {
        int[] clen = new int[]{locale.getLanguage().length(), locale.getCountry().length(), locale.getVariant().length()};
        int localStage = 0;
        int i = 0;
        int b = 1;
        while (i < 3) {
            if (clen[i] > 0) {
                localStage |= b;
            }
            ++i;
            b *= 2;
        }
        return localStage;
    }

    private Locale getNext(Locale locale) {
        switch (this.stage) {
            case 0: {
                this.stage = -1;
                return null;
            }
            case 1: 
            case 2: {
                this.stage = 0;
                return LocaleUtil.BASE_LOCALE;
            }
            case 3: 
            case 5: {
                this.stage = 1;
                return new Locale(locale.getLanguage());
            }
            case 6: {
                this.stage = 2;
                return new Locale("", locale.getCountry());
            }
            case 7: {
                this.stage = 3;
                return new Locale(locale.getLanguage(), locale.getCountry());
            }
        }
        throw new IllegalStateException("Illegal locale stage: " + this.stage);
    }

    @Override
    public Locale next() {
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        if (this.incDefault) {
            if (this.stage == 0) {
                this.next = Locale.getDefault();
                this.incDefault = false;
                this.stage = this.getLocaleStage(this.next);
            } else if (Locale.getDefault().equals(this.next)) {
                this.incDefault = false;
            }
        }
        Locale rv = this.next;
        this.next = this.getNext(this.next);
        return rv;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

