/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.commons.l10n.support;

import com.mysema.commons.l10n.support.LocaleIterator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LocaleUtil {
    private static final int BASE = 0;
    private static final int LANG = 1;
    private static final int LANG_COUNTRY = 2;
    private static final int LANG_COUNTRY_VARIANT = 3;
    public static final Locale BASE_LOCALE = new Locale("");

    private LocaleUtil() {
    }

    public static Locale parseLocale(String locale) {
        if (locale == null) {
            return BASE_LOCALE;
        }
        String[] s = locale.split("[_-]", 3);
        switch (s.length) {
            case 0: {
                return BASE_LOCALE;
            }
            case 1: {
                return new Locale(s[0]);
            }
            case 2: {
                return new Locale(s[0], s[1]);
            }
            case 3: {
                return new Locale(s[0], s[1], s[2]);
            }
        }
        throw new IllegalArgumentException(locale);
    }

    public static String toLang(Locale locale) {
        StringBuilder sb = new StringBuilder(5);
        if (LocaleUtil.isNotEmpty(locale.getLanguage())) {
            sb.append(locale.getLanguage().toLowerCase());
        }
        if (LocaleUtil.isNotEmpty(locale.getCountry())) {
            sb.append('-');
            sb.append(locale.getCountry().toLowerCase());
        }
        return sb.toString();
    }

    public static <V> V getLocalized(Map<Locale, V> values, Iterable<Locale> locales, V defaultValue) {
        return LocaleUtil.getLocalized(values, locales.iterator(), defaultValue);
    }

    public static <Value> Value getLocalized(Map<Locale, Value> values, Iterator<Locale> localeIter, Value defaultValue) {
        Value rv = null;
        if (values != null && values.size() > 0) {
            while (rv == null && localeIter.hasNext()) {
                rv = values.get(localeIter.next());
            }
            if (rv == null && !values.isEmpty()) {
                rv = values.entrySet().iterator().next().getValue();
            }
        }
        if (rv == null) {
            rv = defaultValue;
        }
        return rv;
    }

    public static <Value> Value getLocalized(Map<Locale, Value> values, Locale locale, Value defaultValue) {
        return LocaleUtil.getLocalized(values, new LocaleIterator(locale, true), defaultValue);
    }

    public static Map<Locale, String> parseLiterals(String string) {
        HashMap<Locale, String> rv = new HashMap<Locale, String>();
        String[] literals = string.split(";");
        for (int i = 0; i < literals.length; ++i) {
            String[] lsplit = literals[i].split(":", 2);
            if (lsplit.length != 2) continue;
            rv.put(LocaleUtil.parseLocale(lsplit[0].trim()), lsplit[1].trim());
        }
        return rv;
    }

    public static String encodeLiterals(Map<Locale, String> literals) {
        Set<Map.Entry<Locale, String>> entries = literals.entrySet();
        StringBuilder sb = new StringBuilder(entries.size() * 10);
        for (Map.Entry<Locale, String> entry : entries) {
            if (sb.length() > 0) {
                sb.append("; ");
            }
            sb.append(entry.getKey());
            sb.append(": ");
            sb.append(entry.getValue());
        }
        return sb.toString();
    }

    private static boolean isNotEmpty(String str) {
        return str != null && !str.isEmpty();
    }
}

