/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.commons.l10n.support;

import com.mysema.commons.l10n.State;
import com.mysema.commons.l10n.States;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalizedNameIterator
implements Iterator<String> {
    private String suffix;
    private StringBuilder buffer;
    private String baseName;
    private int curstate;
    private Locale locale;
    private Set<String> seen;
    private State[] states;
    private String next;
    private static final State[] DEFAULT_SEARCH_PATH = new State[]{States.LCV, States.LC, States.L, States.DEFAULT, States.LCV, States.LC, States.L, States.BARE};

    public LocalizedNameIterator(String baseName, Locale locale, String suffix) {
        this(baseName, locale, suffix, DEFAULT_SEARCH_PATH);
    }

    public LocalizedNameIterator(String baseName, Locale locale, String suffix, State[] states) {
        if (baseName == null) {
            throw new IllegalArgumentException("baseName was null");
        }
        if (states == null) {
            throw new IllegalArgumentException("states was null");
        }
        this.locale = locale;
        if (this.locale == null) {
            this.locale = new Locale("");
        }
        this.suffix = suffix;
        if (this.suffix == null) {
            this.suffix = "";
        }
        this.states = (State[])states.clone();
        this.baseName = baseName;
        if (this.baseName.endsWith(this.suffix)) {
            this.baseName = this.baseName.substring(0, this.baseName.length() - this.suffix.length());
        }
        this.buffer = new StringBuilder(this.baseName.length() + 16);
        this.curstate = 0;
        this.seen = new HashSet<String>((int)((double)states.length / 0.7));
    }

    @Override
    public boolean hasNext() {
        this.advance();
        return this.next != null;
    }

    @Override
    public String next() {
        this.advance();
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        String result = this.next;
        this.next = null;
        return result;
    }

    private void reset() {
        this.buffer.replace(0, this.baseName.length(), this.baseName);
        this.buffer.setLength(this.baseName.length());
    }

    private void advance() {
        if (this.next == null && this.curstate < this.states.length) {
            boolean found;
            this.reset();
            do {
                this.locale = this.states[this.curstate].convert(this.locale);
                found = false;
                if (!(found = this.states[this.curstate++].apply(this.locale, this.buffer)) || this.seen.add(this.buffer.toString())) continue;
                this.reset();
                found = false;
            } while (!found && this.curstate < this.states.length);
            if (found) {
                this.buffer.append(this.suffix);
                this.next = this.buffer.toString();
            }
        }
    }

    public Locale getCurrentLocale() {
        if (this.curstate == 0) {
            throw new NoSuchElementException();
        }
        return this.states[this.curstate - 1].filter(this.locale);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

