/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.commons.lang;

import java.util.Collection;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Assert {
    public static String hasText(String str) {
        return Assert.hasText(str, "str hasn't text");
    }

    public static String hasText(String str, String msg) {
        int strLen = Assert.hasLength(str).length();
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return str;
        }
        throw new IllegalArgumentException(msg);
    }

    public static <T> T notNull(T object) {
        return Assert.notNull(object, "null object");
    }

    public static <T> T notNull(T object, String msg) {
        return Assert.assertThat(object != null, msg, object);
    }

    public static String hasLength(String str) {
        return Assert.hasLength(str, "empty string");
    }

    public static String hasLength(String str, String msg) {
        return Assert.assertThat(str != null && str.length() > 0, msg, str);
    }

    public static <T> T[] notEmpty(T[] objects) {
        return Assert.notEmpty(objects, "objects is empty");
    }

    public static <T> T[] notEmpty(T[] objects, String msg) {
        return Assert.assertThat(objects != null && objects.length > 0, msg, objects);
    }

    public static <M extends Map<?, ?>> M notEmpty(M map) {
        return Assert.notEmpty(map, "map is empty");
    }

    public static <M extends Map<?, ?>> M notEmpty(M map, String msg) {
        return Assert.assertThat(!map.isEmpty(), msg, map);
    }

    public static <C extends Collection<?>> C notEmpty(C col) {
        return Assert.notEmpty(col, "col is empty");
    }

    public static <C extends Collection<?>> C notEmpty(C col, String msg) {
        return Assert.assertThat(!col.isEmpty(), msg, col);
    }

    private static <T> T assertThat(boolean condition, String msg, T rv) {
        if (!condition) {
            throw new IllegalArgumentException(msg);
        }
        return rv;
    }
}

