/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.apt;

import com.mysema.query.apt.Configuration;
import com.mysema.query.apt.TypeArgumentsException;
import com.mysema.query.apt.UnsupportedTypeException;
import com.mysema.query.codegen.ClassTypeModel;
import com.mysema.query.codegen.EntityModel;
import com.mysema.query.codegen.SimpleTypeModel;
import com.mysema.query.codegen.TypeCategory;
import com.mysema.query.codegen.TypeExtendsModel;
import com.mysema.query.codegen.TypeModel;
import com.mysema.query.codegen.TypeModelFactory;
import com.mysema.query.codegen.TypeSuperModel;
import com.mysema.query.util.TypeUtil;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.TypeVisitor;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.Elements;

public class APTTypeModelFactory
implements TypeVisitor<TypeModel, Elements> {
    private final Configuration configuration;
    private final ProcessingEnvironment env;
    private final TypeModelFactory factory;
    private final TypeModel defaultValue;
    private final Map<List<String>, EntityModel> entityTypeCache = new HashMap<List<String>, EntityModel>();
    private final Map<List<String>, TypeModel> cache = new HashMap<List<String>, TypeModel>();
    private final List<Class<? extends Annotation>> entityAnnotations;
    private final TypeElement numberType;
    private final TypeElement comparableType;

    public APTTypeModelFactory(ProcessingEnvironment env, Configuration configuration, TypeModelFactory factory, List<Class<? extends Annotation>> annotations) {
        this.env = env;
        this.configuration = configuration;
        this.factory = factory;
        this.defaultValue = factory.create(Object.class);
        this.entityAnnotations = annotations;
        this.numberType = env.getElementUtils().getTypeElement(Number.class.getName());
        this.comparableType = env.getElementUtils().getTypeElement(Comparable.class.getName());
    }

    private List<String> getKey(TypeMirror type, boolean deep) {
        ArrayList<String> key = new ArrayList<String>();
        key.add(((Object)type).toString());
        if (type.getKind() == TypeKind.TYPEVAR) {
            TypeVariable t = (TypeVariable)type;
            if (t.getUpperBound() != null) {
                key.addAll(this.getKey(t.getUpperBound(), false));
            }
            if (t.getLowerBound() != null) {
                key.addAll(this.getKey(t.getLowerBound(), false));
            }
        } else if (type.getKind() == TypeKind.WILDCARD) {
            WildcardType t = (WildcardType)type;
            if (t.getExtendsBound() != null) {
                key.addAll(this.getKey(t.getExtendsBound(), false));
            }
            if (t.getSuperBound() != null) {
                key.addAll(this.getKey(t.getSuperBound(), false));
            }
        } else if (type.getKind() == TypeKind.DECLARED) {
            DeclaredType t = (DeclaredType)type;
            for (TypeMirror typeMirror : t.getTypeArguments()) {
                key.addAll(deep ? this.getKey(typeMirror, false) : Collections.singleton(((Object)typeMirror).toString()));
            }
        }
        return key;
    }

    public EntityModel createEntityModel(TypeMirror type, Elements el) {
        List<String> key = this.getKey(type, true);
        if (this.entityTypeCache.containsKey(key)) {
            return this.entityTypeCache.get(key);
        }
        this.entityTypeCache.put(key, null);
        TypeModel value = type.accept(this, el);
        if (value != null) {
            EntityModel entityModel = this.asEntityModel(type, el, value);
            this.entityTypeCache.put(key, entityModel);
            return entityModel;
        }
        return null;
    }

    public TypeModel create(TypeMirror type, Elements el) {
        List<String> key = this.getKey(type, true);
        if (this.entityTypeCache.containsKey(key)) {
            return (TypeModel)this.entityTypeCache.get(key);
        }
        if (this.cache.containsKey(key)) {
            return this.cache.get(key);
        }
        this.cache.put(key, null);
        TypeModel value = type.accept(this, el);
        if (value != null && value.getCategory() == TypeCategory.ENTITY) {
            value = this.asEntityModel(type, el, value);
            this.entityTypeCache.put(key, (EntityModel)value);
        } else {
            this.cache.put(key, value);
        }
        return value;
    }

    private EntityModel asEntityModel(TypeMirror type, Elements el, TypeModel value) {
        WildcardType wildcard;
        if (type.getKind() == TypeKind.TYPEVAR) {
            TypeVariable typeVar = (TypeVariable)type;
            if (typeVar.getUpperBound() != null) {
                type = typeVar.getUpperBound();
            }
        } else if (type.getKind() == TypeKind.WILDCARD && (wildcard = (WildcardType)type).getExtendsBound() != null) {
            type = wildcard.getExtendsBound();
        }
        Collection<Object> superTypes = Collections.emptySet();
        if (type.getKind() == TypeKind.DECLARED) {
            DeclaredType declaredType = (DeclaredType)type;
            TypeElement e = (TypeElement)declaredType.asElement();
            if (e.getKind() == ElementKind.CLASS) {
                superTypes = Collections.singleton(this.create(e.getSuperclass(), el).getFullName());
            } else {
                superTypes = new ArrayList(e.getInterfaces().size());
                for (TypeMirror typeMirror : e.getInterfaces()) {
                    TypeModel iface = this.create(typeMirror, el);
                    if (iface.getFullName().startsWith("java")) continue;
                    superTypes.add(iface.getFullName());
                }
            }
        } else {
            throw new IllegalArgumentException("Unsupported type kind " + (Object)((Object)type.getKind()));
        }
        return new EntityModel(this.configuration.getNamePrefix(), value, superTypes);
    }

    @Override
    public TypeModel visit(TypeMirror t) {
        throw new UnsupportedTypeException(t);
    }

    @Override
    public TypeModel visit(TypeMirror t, Elements p) {
        throw new UnsupportedTypeException(t);
    }

    @Override
    public TypeModel visitArray(ArrayType t, Elements p) {
        return this.factory.createArrayType(this.create(t.getComponentType(), p));
    }

    @Override
    public TypeModel visitDeclared(DeclaredType t, Elements p) {
        if (t.asElement() != null && t.asElement() instanceof TypeElement) {
            TypeElement typeElement = (TypeElement)t.asElement();
            switch (typeElement.getKind()) {
                case ENUM: {
                    return this.createEnumType(t, typeElement, p);
                }
                case CLASS: {
                    return this.createClassType(t, typeElement, p);
                }
                case INTERFACE: {
                    return this.createInterfaceType(t, typeElement, p);
                }
            }
            throw new IllegalArgumentException("Illegal type " + typeElement);
        }
        throw new IllegalArgumentException("Unsupported element type " + t.asElement());
    }

    private TypeModel createInterfaceType(DeclaredType t, TypeElement typeElement, Elements p) {
        for (Class<? extends Annotation> entityAnn : this.entityAnnotations) {
            if (typeElement.getAnnotation(entityAnn) == null) continue;
            return this.create(typeElement, TypeCategory.ENTITY, p, t.getTypeArguments());
        }
        String name = typeElement.getQualifiedName().toString();
        String simpleName = typeElement.getSimpleName().toString();
        Iterator<? extends TypeMirror> i = t.getTypeArguments().iterator();
        Class cl = TypeUtil.safeForName((String)name);
        if (cl == null) {
            return this.create(typeElement, TypeCategory.get((String)name), p, t.getTypeArguments());
        }
        if (Map.class.isAssignableFrom(cl)) {
            if (!i.hasNext()) {
                throw new TypeArgumentsException(simpleName);
            }
            return this.factory.createMapType(this.create(i.next(), p), this.create(i.next(), p));
        }
        if (List.class.isAssignableFrom(cl)) {
            if (!i.hasNext()) {
                throw new TypeArgumentsException(simpleName);
            }
            return this.factory.createListType(this.create(i.next(), p));
        }
        if (Set.class.isAssignableFrom(cl)) {
            if (!i.hasNext()) {
                throw new TypeArgumentsException(simpleName);
            }
            return this.factory.createSetType(this.create(i.next(), p));
        }
        if (Collection.class.isAssignableFrom(cl)) {
            if (!i.hasNext()) {
                throw new TypeArgumentsException(simpleName);
            }
            return this.factory.createCollectionType(this.create(i.next(), p));
        }
        return this.create(typeElement, TypeCategory.get((String)name), p, t.getTypeArguments());
    }

    private TypeModel createEnumType(DeclaredType t, TypeElement typeElement, Elements p) {
        for (Class<? extends Annotation> entityAnn : this.entityAnnotations) {
            if (typeElement.getAnnotation(entityAnn) == null) continue;
            return this.create(typeElement, TypeCategory.ENTITY, p, t.getTypeArguments());
        }
        return this.create(typeElement, TypeCategory.SIMPLE, p, t.getTypeArguments());
    }

    private TypeModel createClassType(DeclaredType t, TypeElement typeElement, Elements p) {
        for (Class<? extends Annotation> entityAnn : this.entityAnnotations) {
            if (typeElement.getAnnotation(entityAnn) == null) continue;
            return this.create(typeElement, TypeCategory.ENTITY, p, t.getTypeArguments());
        }
        String name = typeElement.getQualifiedName().toString();
        TypeCategory typeCategory = TypeCategory.get((String)name);
        if (typeCategory != TypeCategory.NUMERIC && this.isAssignable(typeElement, this.comparableType) && this.isSubType(typeElement, this.numberType)) {
            typeCategory = TypeCategory.NUMERIC;
        } else if (!typeCategory.isSubCategoryOf(TypeCategory.COMPARABLE) && this.isAssignable(typeElement, this.comparableType)) {
            typeCategory = TypeCategory.COMPARABLE;
        }
        return this.create(typeElement, typeCategory, p, t.getTypeArguments());
    }

    private boolean isSubType(TypeElement type1, TypeElement type2) {
        return this.env.getTypeUtils().isSubtype(type1.asType(), type2.asType());
    }

    private boolean isAssignable(TypeElement type1, TypeElement type2) {
        TypeMirror t1 = type1.asType();
        TypeMirror t2 = this.env.getTypeUtils().erasure(type2.asType());
        return this.env.getTypeUtils().isAssignable(t1, t2);
    }

    private TypeModel create(TypeElement typeElement, TypeCategory category, Elements p, List<? extends TypeMirror> typeArgs) {
        String name = typeElement.getQualifiedName().toString();
        String simpleName = typeElement.getSimpleName().toString();
        String packageName = p.getPackageOf(typeElement).getQualifiedName().toString();
        TypeModel[] params = new TypeModel[typeArgs.size()];
        for (int i = 0; i < params.length; ++i) {
            params[i] = this.create(typeArgs.get(i), p);
        }
        return new SimpleTypeModel(category, name, packageName, simpleName, typeElement.getModifiers().contains((Object)Modifier.FINAL), params);
    }

    @Override
    public TypeModel visitError(ErrorType t, Elements p) {
        throw new UnsupportedTypeException(t);
    }

    @Override
    public TypeModel visitExecutable(ExecutableType t, Elements p) {
        throw new UnsupportedTypeException(t);
    }

    @Override
    public TypeModel visitNoType(NoType t, Elements p) {
        return this.defaultValue;
    }

    @Override
    public TypeModel visitNull(NullType t, Elements p) {
        throw new UnsupportedTypeException(t);
    }

    @Override
    public TypeModel visitPrimitive(PrimitiveType t, Elements p) {
        switch (t.getKind()) {
            case BOOLEAN: {
                return new ClassTypeModel(TypeCategory.BOOLEAN, Boolean.class, Boolean.TYPE);
            }
            case BYTE: {
                return new ClassTypeModel(TypeCategory.NUMERIC, Byte.class, Byte.TYPE);
            }
            case CHAR: {
                return new ClassTypeModel(TypeCategory.COMPARABLE, Character.class, Character.TYPE);
            }
            case DOUBLE: {
                return new ClassTypeModel(TypeCategory.NUMERIC, Double.class, Double.TYPE);
            }
            case FLOAT: {
                return new ClassTypeModel(TypeCategory.NUMERIC, Float.class, Float.TYPE);
            }
            case INT: {
                return new ClassTypeModel(TypeCategory.NUMERIC, Integer.class, Integer.TYPE);
            }
            case LONG: {
                return new ClassTypeModel(TypeCategory.NUMERIC, Long.class, Long.TYPE);
            }
            case SHORT: {
                return new ClassTypeModel(TypeCategory.NUMERIC, Short.class, Short.TYPE);
            }
        }
        throw new IllegalArgumentException("Unsupported type " + t);
    }

    @Override
    public TypeModel visitTypeVariable(TypeVariable t, Elements p) {
        String varName = t.toString();
        if (t.getUpperBound() != null) {
            return new TypeExtendsModel(varName, t.getUpperBound().accept(this, p));
        }
        if (t.getLowerBound() != null && !(t.getLowerBound() instanceof NullType)) {
            return new TypeSuperModel(varName, t.getLowerBound().accept(this, p));
        }
        return null;
    }

    @Override
    public TypeModel visitUnknown(TypeMirror t, Elements p) {
        throw new UnsupportedTypeException(t);
    }

    @Override
    public TypeModel visitWildcard(WildcardType t, Elements p) {
        if (t.getExtendsBound() != null) {
            return new TypeExtendsModel(t.getExtendsBound().accept(this, p));
        }
        if (t.getSuperBound() != null) {
            return new TypeSuperModel(t.getSuperBound().accept(this, p));
        }
        return null;
    }
}

