/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.apt;

import com.mysema.query.annotations.PropertyType;
import com.mysema.query.annotations.QueryType;
import com.mysema.query.apt.APTTypeModelFactory;
import com.mysema.query.apt.Configuration;
import com.mysema.query.codegen.ConstructorModel;
import com.mysema.query.codegen.EntityModel;
import com.mysema.query.codegen.ParameterModel;
import com.mysema.query.codegen.TypeCategory;
import com.mysema.query.codegen.TypeModel;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleElementVisitor6;
import net.jcip.annotations.Immutable;

@Immutable
public final class DTOElementVisitor
extends SimpleElementVisitor6<EntityModel, Void> {
    private final ProcessingEnvironment env;
    private final APTTypeModelFactory typeFactory;
    private final Configuration configuration;

    DTOElementVisitor(ProcessingEnvironment env, Configuration configuration, APTTypeModelFactory typeFactory) {
        this.env = env;
        this.configuration = configuration;
        this.typeFactory = typeFactory;
    }

    @Override
    public EntityModel visitType(TypeElement e, Void p) {
        Elements elementUtils = this.env.getElementUtils();
        TypeModel c = this.typeFactory.create(e.asType(), elementUtils);
        EntityModel classModel = new EntityModel(this.configuration.getNamePrefix(), c.as(TypeCategory.ENTITY));
        List<? extends Element> elements = e.getEnclosedElements();
        for (ExecutableElement constructor : ElementFilter.constructorsIn(elements)) {
            if (!this.configuration.isValidConstructor(constructor)) continue;
            ArrayList<ParameterModel> parameters = new ArrayList<ParameterModel>(constructor.getParameters().size());
            for (VariableElement variableElement : constructor.getParameters()) {
                QueryType qt;
                TypeModel paramType = this.typeFactory.create(variableElement.asType(), elementUtils);
                if (variableElement.getAnnotation(QueryType.class) != null && (qt = variableElement.getAnnotation(QueryType.class)).value() != PropertyType.NONE) {
                    TypeCategory typeCategory = TypeCategory.get((PropertyType)qt.value());
                    paramType = paramType.as(typeCategory);
                }
                parameters.add(new ParameterModel(variableElement.getSimpleName().toString(), paramType));
            }
            classModel.addConstructor(new ConstructorModel(parameters));
        }
        return classModel;
    }
}

