/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.apt;

import com.mysema.query.annotations.PropertyType;
import com.mysema.query.annotations.QueryInit;
import com.mysema.query.annotations.QueryType;
import com.mysema.query.apt.APTTypeModelFactory;
import com.mysema.query.apt.Configuration;
import com.mysema.query.apt.VisitorConfig;
import com.mysema.query.codegen.ConstructorModel;
import com.mysema.query.codegen.EntityModel;
import com.mysema.query.codegen.ParameterModel;
import com.mysema.query.codegen.PropertyModel;
import com.mysema.query.codegen.TypeCategory;
import com.mysema.query.codegen.TypeModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleElementVisitor6;
import net.jcip.annotations.Immutable;
import org.apache.commons.lang.StringUtils;

@Immutable
public final class EntityElementVisitor
extends SimpleElementVisitor6<EntityModel, Void> {
    private final ProcessingEnvironment env;
    private final APTTypeModelFactory typeFactory;
    private final Configuration configuration;

    EntityElementVisitor(ProcessingEnvironment env, Configuration configuration, APTTypeModelFactory typeFactory) {
        this.env = env;
        this.configuration = configuration;
        this.typeFactory = typeFactory;
    }

    @Override
    public EntityModel visitType(TypeElement e, Void p) {
        Elements elementUtils = this.env.getElementUtils();
        EntityModel entityModel = this.typeFactory.createEntityModel(e.asType(), elementUtils);
        List<? extends Element> elements = e.getEnclosedElements();
        VisitorConfig config = this.configuration.getConfig(e, elements);
        HashSet<String> blockedProperties = new HashSet<String>();
        HashMap<String, PropertyModel> properties = new HashMap<String, PropertyModel>();
        HashMap<String, TypeCategory> types = new HashMap<String, TypeCategory>();
        if (config.isVisitConstructors()) {
            this.visitConstructors(elementUtils, entityModel, elements);
        }
        if (config.isVisitFields()) {
            this.visitFields(elementUtils, entityModel, elements, blockedProperties, properties, types);
        }
        if (config.isVisitMethods()) {
            this.visitMethods(elementUtils, entityModel, elements, blockedProperties, properties, types);
        }
        for (Map.Entry entry : properties.entrySet()) {
            if (blockedProperties.contains(entry.getKey())) continue;
            entityModel.addProperty((PropertyModel)entry.getValue());
        }
        return entityModel;
    }

    private void visitConstructors(Elements elementUtils, EntityModel entityModel, List<? extends Element> elements) {
        for (ExecutableElement constructor : ElementFilter.constructorsIn(elements)) {
            if (!this.configuration.isValidConstructor(constructor)) continue;
            ArrayList<ParameterModel> parameters = new ArrayList<ParameterModel>(constructor.getParameters().size());
            for (VariableElement variableElement : constructor.getParameters()) {
                QueryType qt;
                TypeModel paramType = this.typeFactory.create(variableElement.asType(), elementUtils);
                if (variableElement.getAnnotation(QueryType.class) != null && (qt = variableElement.getAnnotation(QueryType.class)).value() != PropertyType.NONE) {
                    TypeCategory typeCategory = TypeCategory.get((PropertyType)qt.value());
                    paramType = paramType.as(typeCategory);
                }
                parameters.add(new ParameterModel(variableElement.getSimpleName().toString(), paramType));
            }
            entityModel.addConstructor(new ConstructorModel(parameters));
        }
    }

    private void visitMethods(Elements elementUtils, EntityModel entityModel, List<? extends Element> elements, Set<String> blockedProperties, Map<String, PropertyModel> properties, Map<String, TypeCategory> types) {
        for (ExecutableElement method : ElementFilter.methodsIn(elements)) {
            String name = method.getSimpleName().toString();
            if (name.startsWith("get") && method.getParameters().isEmpty()) {
                name = StringUtils.uncapitalize((String)name.substring(3));
            } else {
                if (!name.startsWith("is") || !method.getParameters().isEmpty()) continue;
                name = StringUtils.uncapitalize((String)name.substring(2));
            }
            if (this.configuration.isValidGetter(method)) {
                try {
                    TypeModel propertyType = this.typeFactory.create(method.getReturnType(), elementUtils);
                    if (method.getAnnotation(QueryType.class) != null) {
                        TypeCategory typeCategory = TypeCategory.get((PropertyType)method.getAnnotation(QueryType.class).value());
                        if (typeCategory == null) {
                            blockedProperties.add(name);
                            continue;
                        }
                        if (blockedProperties.contains(name)) continue;
                        propertyType = propertyType.as(typeCategory);
                    } else if (types.containsKey(name)) {
                        propertyType = propertyType.as(types.get(name));
                    }
                    String[] inits = new String[]{};
                    if (method.getAnnotation(QueryInit.class) != null) {
                        inits = method.getAnnotation(QueryInit.class).value();
                    }
                    properties.put(name, new PropertyModel(entityModel, name, propertyType, inits));
                    continue;
                }
                catch (IllegalArgumentException ex) {
                    StringBuilder builder = new StringBuilder();
                    builder.append("Caught exception for method ");
                    builder.append(entityModel.getFullName()).append("#").append(method.getSimpleName());
                    throw new RuntimeException(builder.toString(), ex);
                }
            }
            if (!this.configuration.isBlockedGetter(method)) continue;
            blockedProperties.add(name);
        }
    }

    private void visitFields(Elements elementUtils, EntityModel entityModel, List<? extends Element> elements, Set<String> blockedProperties, Map<String, PropertyModel> properties, Map<String, TypeCategory> types) {
        for (VariableElement field : ElementFilter.fieldsIn(elements)) {
            String name = field.getSimpleName().toString();
            if (this.configuration.isValidField(field)) {
                try {
                    TypeModel fieldType = this.typeFactory.create(field.asType(), elementUtils);
                    if (field.getAnnotation(QueryType.class) != null) {
                        TypeCategory typeCategory = TypeCategory.get((PropertyType)field.getAnnotation(QueryType.class).value());
                        if (typeCategory == null) {
                            blockedProperties.add(name);
                            continue;
                        }
                        fieldType = fieldType.as(typeCategory);
                        types.put(name, typeCategory);
                    }
                    String[] inits = new String[]{};
                    if (field.getAnnotation(QueryInit.class) != null) {
                        inits = field.getAnnotation(QueryInit.class).value();
                    }
                    properties.put(name, new PropertyModel(entityModel, name, fieldType, inits));
                    continue;
                }
                catch (IllegalArgumentException ex) {
                    StringBuilder builder = new StringBuilder();
                    builder.append("Caught exception for field ");
                    builder.append(entityModel.getFullName()).append("#").append(field.getSimpleName());
                    throw new RuntimeException(builder.toString(), ex);
                }
            }
            if (!this.configuration.isBlockedField(field)) continue;
            blockedProperties.add(name);
        }
    }
}

