/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.apt;

import com.mysema.commons.lang.Assert;
import com.mysema.query.annotations.QueryProjection;
import com.mysema.query.apt.APTTypeModelFactory;
import com.mysema.query.apt.Configuration;
import com.mysema.query.apt.DTOElementVisitor;
import com.mysema.query.apt.EntityElementVisitor;
import com.mysema.query.codegen.EntityModel;
import com.mysema.query.codegen.EntityModelFactory;
import com.mysema.query.codegen.Serializer;
import com.mysema.query.codegen.SerializerConfig;
import com.mysema.query.codegen.TypeModel;
import com.mysema.query.codegen.TypeModelFactory;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Stack;
import javax.annotation.Nullable;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import net.jcip.annotations.Immutable;

@Immutable
public class Processor {
    private final ProcessingEnvironment env;
    private final APTTypeModelFactory typeFactory;
    private final Configuration configuration;
    private final EntityModelFactory entityModelFactory;

    public Processor(ProcessingEnvironment env, Configuration configuration) {
        this.configuration = configuration;
        ArrayList<Class<? extends Annotation>> anns = new ArrayList<Class<? extends Annotation>>();
        anns.add(configuration.getEntityAnn());
        if (configuration.getSuperTypeAnn() != null) {
            anns.add(configuration.getSuperTypeAnn());
        }
        if (configuration.getEmbeddableAnn() != null) {
            anns.add(configuration.getEmbeddableAnn());
        }
        this.env = (ProcessingEnvironment)Assert.notNull((Object)env);
        TypeModelFactory factory = new TypeModelFactory(anns);
        this.typeFactory = new APTTypeModelFactory(env, configuration, factory, anns);
        this.entityModelFactory = configuration.getSkipAnn() != null ? new EntityModelFactory(factory, configuration.getSkipAnn()) : new EntityModelFactory(factory);
    }

    public void process(RoundEnvironment roundEnv) {
        HashMap<String, EntityModel> actualSupertypes = new HashMap<String, EntityModel>();
        HashMap<String, EntityModel> allSupertypes = new HashMap<String, EntityModel>();
        HashMap<String, EntityModel> entityTypes = new HashMap<String, EntityModel>();
        HashMap<String, EntityModel> embeddables = new HashMap<String, EntityModel>();
        HashMap<String, EntityModel> dtos = new HashMap<String, EntityModel>();
        EntityElementVisitor entityVisitor = new EntityElementVisitor(this.env, this.configuration, this.typeFactory);
        DTOElementVisitor dtoVisitor = new DTOElementVisitor(this.env, this.configuration, this.typeFactory);
        if (this.configuration.getSuperTypeAnn() != null) {
            this.handleSupertypes(roundEnv, actualSupertypes, entityVisitor);
            allSupertypes.putAll(actualSupertypes);
        }
        this.handleEntities(roundEnv, allSupertypes, entityTypes, entityVisitor);
        if (this.configuration.getEmbeddableAnn() != null) {
            this.handleEmbeddables(roundEnv, allSupertypes, embeddables, entityVisitor);
        }
        this.handleDTOs(roundEnv, dtos, dtoVisitor);
        this.serialize(this.configuration.getSupertypeSerializer(), actualSupertypes);
        this.serialize(this.configuration.getEntitySerializer(), entityTypes);
        this.serialize(this.configuration.getEmbeddableSerializer(), embeddables);
        this.serialize(this.configuration.getDTOSerializer(), dtos);
    }

    private void handleDTOs(RoundEnvironment roundEnv, Map<String, EntityModel> dtos, DTOElementVisitor dtoVisitor) {
        HashSet<Element> visitedDTOTypes = new HashSet<Element>();
        for (Element element : roundEnv.getElementsAnnotatedWith(QueryProjection.class)) {
            Element parent = element.getEnclosingElement();
            if (parent.getAnnotation(this.configuration.getEntityAnn()) != null || parent.getAnnotation(this.configuration.getEmbeddableAnn()) != null || visitedDTOTypes.contains(parent)) continue;
            EntityModel model = parent.accept(dtoVisitor, null);
            dtos.put(model.getFullName(), model);
            visitedDTOTypes.add(parent);
        }
    }

    private void handleSupertypes(RoundEnvironment roundEnv, Map<String, EntityModel> superTypes, EntityElementVisitor entityVisitor) {
        for (Element element : roundEnv.getElementsAnnotatedWith(this.configuration.getSuperTypeAnn())) {
            if (this.configuration.getEmbeddableAnn() != null && element.getAnnotation(this.configuration.getEmbeddableAnn()) != null) continue;
            EntityModel model = element.accept(entityVisitor, null);
            superTypes.put(model.getFullName(), model);
        }
        for (EntityModel entityModel : superTypes.values()) {
            this.addSupertypeFields(entityModel, superTypes);
        }
    }

    private void handleEmbeddables(RoundEnvironment roundEnv, Map<String, EntityModel> superTypes, Map<String, EntityModel> embeddables, EntityElementVisitor entityVisitor) {
        for (Element element : roundEnv.getElementsAnnotatedWith(this.configuration.getEmbeddableAnn())) {
            EntityModel model = element.accept(entityVisitor, null);
            embeddables.put(model.getFullName(), model);
        }
        superTypes.putAll(embeddables);
        for (EntityModel entityModel : embeddables.values()) {
            this.addSupertypeFields(entityModel, superTypes);
        }
    }

    private void handleEntities(RoundEnvironment roundEnv, Map<String, EntityModel> superTypes, Map<String, EntityModel> entityTypes, EntityElementVisitor entityVisitor) {
        for (Element element : roundEnv.getElementsAnnotatedWith(this.configuration.getEntityAnn())) {
            if (this.configuration.getEmbeddableAnn() != null && element.getAnnotation(this.configuration.getEmbeddableAnn()) != null) continue;
            EntityModel model = element.accept(entityVisitor, null);
            entityTypes.put(model.getFullName(), model);
        }
        superTypes.putAll(entityTypes);
        for (EntityModel entityModel : entityTypes.values()) {
            this.addSupertypeFields(entityModel, superTypes);
        }
    }

    private void addSupertypeFields(EntityModel model, Map<String, EntityModel> superTypes) {
        String stype;
        Class<?> superClass;
        boolean singleSuperType = model.getSuperTypes().size() == 1;
        for (String stype2 : model.getSuperTypes()) {
            if (!superTypes.containsKey(stype2)) continue;
            Stack<String> stypeStack = new Stack<String>();
            stypeStack.push(stype2);
            while (!stypeStack.isEmpty()) {
                String top = (String)stypeStack.pop();
                if (!superTypes.containsKey(top)) continue;
                EntityModel sdecl = superTypes.get(top);
                if (singleSuperType && model.getSuperTypes().contains(top)) {
                    model.setSuperModel(sdecl);
                }
                model.include(sdecl);
                for (String type : sdecl.getSuperTypes()) {
                    stypeStack.push(type);
                }
            }
        }
        if (model.getSuperModel() == null && singleSuperType && (superClass = this.safeClassForName(stype = (String)model.getSuperTypes().iterator().next())) != null && !superClass.equals(Object.class) && (this.configuration.getSuperTypeAnn() == null || superClass.getAnnotation(this.configuration.getSuperTypeAnn()) != null || superClass.getAnnotation(this.configuration.getEntityAnn()) != null)) {
            EntityModel type = this.entityModelFactory.create(superClass, this.configuration.getNamePrefix());
            model.include(type);
        }
    }

    @Nullable
    private Class<?> safeClassForName(String stype) {
        try {
            return Class.forName(stype);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serialize(Serializer serializer, Map<String, EntityModel> models) {
        Messager msg = this.env.getMessager();
        for (EntityModel model : models.values()) {
            msg.printMessage(Diagnostic.Kind.NOTE, model.getFullName() + " is processed");
            try {
                String packageName = model.getPackageName();
                String localName = serializer.getPathType((TypeModel)model, model, true);
                String className = packageName + "." + localName;
                JavaFileObject fileObject = this.env.getFiler().createSourceFile(className, new Element[0]);
                Writer writer = fileObject.openWriter();
                try {
                    SerializerConfig serializerConfig = this.configuration.getSerializerConfig(model);
                    serializer.serialize(model, serializerConfig, writer);
                }
                finally {
                    if (writer == null) continue;
                    writer.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                msg.printMessage(Diagnostic.Kind.ERROR, e.getMessage());
            }
        }
    }
}

