/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.apt.jdo;

import com.mysema.query.apt.Processor;
import com.mysema.query.apt.SimpleConfiguration;
import java.lang.annotation.Annotation;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;

@SupportedAnnotationTypes(value={"*"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public class JDOAnnotationProcessor
extends AbstractProcessor {
    private Class<? extends Annotation> entity;
    private Class<? extends Annotation> embeddable;
    private Class<? extends Annotation> skip;

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Running " + this.getClass().getSimpleName());
            this.entity = Class.forName("javax.jdo.annotations.PersistenceCapable");
            this.embeddable = Class.forName("javax.jdo.annotations.EmbeddedOnly");
            this.skip = Class.forName("javax.jdo.annotations.NotPersistent");
            SimpleConfiguration configuration = new SimpleConfiguration(roundEnv, this.entity, null, this.embeddable, this.skip);
            configuration.setUseGetters(false);
            Processor processor = new Processor(this.processingEnv, configuration);
            processor.process(roundEnv);
            return true;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

