/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.apt;

import com.mysema.codegen.model.SimpleType;
import com.mysema.codegen.model.Type;
import com.mysema.codegen.model.TypeCategory;
import com.mysema.codegen.model.TypeExtends;
import com.mysema.codegen.model.TypeSuper;
import com.mysema.codegen.model.Types;
import com.mysema.query.annotations.QueryExclude;
import com.mysema.query.apt.Configuration;
import com.mysema.query.apt.SimpleTypeVisitorAdapter;
import com.mysema.query.codegen.EntityType;
import com.mysema.query.codegen.Property;
import com.mysema.query.codegen.QueryTypeFactory;
import com.mysema.query.codegen.Supertype;
import com.mysema.query.codegen.TypeMappings;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.TypeVisitor;
import javax.lang.model.type.WildcardType;

public final class ExtendedTypeFactory {
    private final Map<List<String>, Type> typeCache = new HashMap<List<String>, Type>();
    private final Map<List<String>, EntityType> entityTypeCache = new HashMap<List<String>, EntityType>();
    private final Type defaultType;
    private final Set<Class<? extends Annotation>> entityAnnotations;
    private final ProcessingEnvironment env;
    private final TypeMirror objectType;
    private final TypeMirror numberType;
    private final TypeMirror comparableType;
    private final TypeMirror collectionType;
    private final TypeMirror setType;
    private final TypeMirror listType;
    private final TypeMirror mapType;
    private final TypeMappings typeMappings;
    private final QueryTypeFactory queryTypeFactory;
    private boolean doubleIndexEntities = true;
    private final TypeVisitor<Type, Boolean> visitor = new SimpleTypeVisitorAdapter<Type, Boolean>(){

        @Override
        public Type visitPrimitive(PrimitiveType primitiveType, Boolean p) {
            switch (primitiveType.getKind()) {
                case BOOLEAN: {
                    return Types.BOOLEAN;
                }
                case BYTE: {
                    return Types.BYTE;
                }
                case SHORT: {
                    return Types.SHORT;
                }
                case INT: {
                    return Types.INTEGER;
                }
                case LONG: {
                    return Types.LONG;
                }
                case CHAR: {
                    return Types.CHARACTER;
                }
                case FLOAT: {
                    return Types.FLOAT;
                }
                case DOUBLE: {
                    return Types.DOUBLE;
                }
            }
            return null;
        }

        private Type getPrimitive(PrimitiveType primitiveType) {
            switch (primitiveType.getKind()) {
                case BOOLEAN: {
                    return Types.BOOLEAN_P;
                }
                case BYTE: {
                    return Types.BYTE_P;
                }
                case SHORT: {
                    return Types.SHORT_P;
                }
                case INT: {
                    return Types.INT;
                }
                case LONG: {
                    return Types.LONG_P;
                }
                case CHAR: {
                    return Types.CHAR;
                }
                case FLOAT: {
                    return Types.FLOAT_P;
                }
                case DOUBLE: {
                    return Types.DOUBLE_P;
                }
            }
            return null;
        }

        @Override
        public Type visitNull(NullType nullType, Boolean p) {
            throw new IllegalStateException();
        }

        @Override
        public Type visitArray(ArrayType arrayType, Boolean p) {
            Type type;
            if (arrayType.getComponentType() instanceof PrimitiveType && (type = this.getPrimitive((PrimitiveType)arrayType.getComponentType())) != null) {
                return type.asArrayType();
            }
            return ((Type)this.visit(arrayType.getComponentType(), p)).asArrayType();
        }

        @Override
        public Type visitDeclared(DeclaredType declaredType, Boolean p) {
            if (declaredType.asElement() instanceof TypeElement) {
                TypeElement typeElement = (TypeElement)declaredType.asElement();
                switch (typeElement.getKind()) {
                    case ENUM: {
                        return ExtendedTypeFactory.this.createEnumType(declaredType, typeElement, p);
                    }
                    case ANNOTATION_TYPE: 
                    case CLASS: {
                        return ExtendedTypeFactory.this.createClassType(declaredType, typeElement, p);
                    }
                    case INTERFACE: {
                        return ExtendedTypeFactory.this.createInterfaceType(declaredType, typeElement, p);
                    }
                }
                throw new IllegalArgumentException("Illegal type " + typeElement);
            }
            throw new IllegalArgumentException("Unsupported element type " + declaredType.asElement());
        }

        @Override
        public Type visitError(ErrorType errorType, Boolean p) {
            return this.visitDeclared((DeclaredType)errorType, p);
        }

        @Override
        public Type visitTypeVariable(TypeVariable typeVariable, Boolean p) {
            String varName = typeVariable.toString();
            if (typeVariable.getUpperBound() != null) {
                Type type = (Type)this.visit(typeVariable.getUpperBound(), p);
                return new TypeExtends(varName, type);
            }
            if (typeVariable.getLowerBound() != null && !(typeVariable.getLowerBound() instanceof NullType)) {
                Type type = (Type)this.visit(typeVariable.getLowerBound(), p);
                return new TypeSuper(varName, type);
            }
            return null;
        }

        @Override
        public Type visitWildcard(WildcardType wildardType, Boolean p) {
            if (wildardType.getExtendsBound() != null) {
                Type type = (Type)this.visit(wildardType.getExtendsBound(), p);
                return new TypeExtends(type);
            }
            if (wildardType.getSuperBound() != null) {
                Type type = (Type)this.visit(wildardType.getSuperBound(), p);
                return new TypeSuper(type);
            }
            return null;
        }

        @Override
        public Type visitExecutable(ExecutableType t, Boolean p) {
            throw new IllegalStateException();
        }

        @Override
        public Type visitNoType(NoType t, Boolean p) {
            return ExtendedTypeFactory.this.defaultType;
        }
    };
    private final TypeVisitor<List<String>, Boolean> keyBuilder = new SimpleTypeVisitorAdapter<List<String>, Boolean>(){
        private final List<String> defaultValue = Collections.singletonList("Object");

        private List<String> visitBase(TypeMirror t) {
            ArrayList<String> rv = new ArrayList<String>();
            String name = t.toString();
            if (name.contains("<")) {
                name = name.substring(0, name.indexOf(60));
            }
            rv.add(name);
            return rv;
        }

        @Override
        public List<String> visitPrimitive(PrimitiveType t, Boolean p) {
            return Collections.singletonList(t.toString());
        }

        @Override
        public List<String> visitNull(NullType t, Boolean p) {
            return this.defaultValue;
        }

        @Override
        public List<String> visitArray(ArrayType t, Boolean p) {
            ArrayList<String> rv = new ArrayList<String>((Collection)this.visit(t.getComponentType()));
            rv.add("[]");
            return rv;
        }

        @Override
        public List<String> visitDeclared(DeclaredType t, Boolean p) {
            List<String> rv = this.visitBase(t);
            for (TypeMirror typeMirror : t.getTypeArguments()) {
                if (p.booleanValue()) {
                    rv.addAll((Collection)this.visit(typeMirror, false));
                    continue;
                }
                rv.add(typeMirror.toString());
            }
            return rv;
        }

        @Override
        public List<String> visitError(ErrorType t, Boolean p) {
            return this.visitDeclared((DeclaredType)t, p);
        }

        @Override
        public List<String> visitTypeVariable(TypeVariable t, Boolean p) {
            List<String> rv = this.visitBase(t);
            if (t.getUpperBound() != null) {
                rv.addAll((Collection)this.visit(t.getUpperBound(), p));
            }
            if (t.getLowerBound() != null) {
                rv.addAll((Collection)this.visit(t.getLowerBound(), p));
            }
            return rv;
        }

        @Override
        public List<String> visitWildcard(WildcardType t, Boolean p) {
            List<String> rv = this.visitBase(t);
            if (t.getExtendsBound() != null) {
                rv.addAll((Collection)this.visit(t.getExtendsBound(), p));
            }
            if (t.getSuperBound() != null) {
                rv.addAll((Collection)this.visit(t.getSuperBound(), p));
            }
            return rv;
        }

        @Override
        public List<String> visitExecutable(ExecutableType t, Boolean p) {
            throw new IllegalStateException();
        }

        @Override
        public List<String> visitNoType(NoType t, Boolean p) {
            return this.defaultValue;
        }
    };

    public ExtendedTypeFactory(ProcessingEnvironment env, Configuration configuration, Set<Class<? extends Annotation>> annotations, TypeMappings typeMappings, QueryTypeFactory queryTypeFactory) {
        this.env = env;
        this.defaultType = new TypeExtends((Type)Types.OBJECT);
        this.entityAnnotations = annotations;
        this.objectType = this.getErasedType(Object.class);
        this.numberType = this.getErasedType(Number.class);
        this.comparableType = this.getErasedType(Comparable.class);
        this.collectionType = this.getErasedType(Collection.class);
        this.listType = this.getErasedType(List.class);
        this.setType = this.getErasedType(Set.class);
        this.mapType = this.getErasedType(Map.class);
        this.typeMappings = typeMappings;
        this.queryTypeFactory = queryTypeFactory;
    }

    private TypeMirror getErasedType(Class<?> clazz) {
        return this.env.getTypeUtils().erasure(this.env.getElementUtils().getTypeElement(clazz.getName()).asType());
    }

    private Type createType(TypeElement typeElement, TypeCategory category, List<? extends TypeMirror> typeArgs, boolean deep) {
        String name = typeElement.getQualifiedName().toString();
        String simpleName = typeElement.getSimpleName().toString();
        String packageName = this.env.getElementUtils().getPackageOf(typeElement).getQualifiedName().toString();
        Type[] params = new Type[typeArgs.size()];
        for (int i = 0; i < params.length; ++i) {
            params[i] = this.getType(typeArgs.get(i), deep);
        }
        return new SimpleType(category, name, packageName, simpleName, false, typeElement.getModifiers().contains((Object)Modifier.FINAL), params);
    }

    public Collection<EntityType> getEntityTypes() {
        return this.entityTypeCache.values();
    }

    @Nullable
    public Type getType(TypeMirror typeMirror, boolean deep) {
        List<String> key = this.keyBuilder.visit(typeMirror, true);
        if (this.entityTypeCache.containsKey(key)) {
            return (Type)this.entityTypeCache.get(key);
        }
        if (this.typeCache.containsKey(key)) {
            return this.typeCache.get(key);
        }
        return this.createType(typeMirror, key, deep);
    }

    @Nullable
    private Type createType(TypeMirror typeMirror, List<String> key, boolean deep) {
        this.typeCache.put(key, null);
        Type type = this.visitor.visit(typeMirror, deep);
        if (type != null && (type.getCategory() == TypeCategory.ENTITY || type.getCategory() == TypeCategory.CUSTOM)) {
            EntityType entityType = this.getEntityType(typeMirror, deep);
            this.typeCache.put(key, (Type)entityType);
            return entityType;
        }
        this.typeCache.put(key, type);
        return type;
    }

    private Type createClassType(DeclaredType declaredType, TypeElement typeElement, boolean deep) {
        TypeMirror type;
        String name = typeElement.getQualifiedName().toString();
        TypeCategory typeCategory = TypeCategory.get((String)name);
        if (typeCategory != TypeCategory.NUMERIC && this.isAssignable(typeElement.asType(), this.comparableType) && this.isSubType(typeElement.asType(), this.numberType)) {
            typeCategory = TypeCategory.NUMERIC;
        } else if (!typeCategory.isSubCategoryOf(TypeCategory.COMPARABLE) && this.isAssignable(typeElement.asType(), this.comparableType)) {
            typeCategory = TypeCategory.COMPARABLE;
        }
        if (typeCategory == TypeCategory.SIMPLE) {
            for (Class<? extends Annotation> entityAnn : this.entityAnnotations) {
                if (typeElement.getAnnotation(entityAnn) == null) continue;
                typeCategory = TypeCategory.ENTITY;
            }
        }
        List<? extends TypeMirror> arguments = declaredType.getTypeArguments();
        if (name.equals("")) {
            type = this.objectType;
            if (typeCategory == TypeCategory.COMPARABLE) {
                type = this.comparableType;
            }
            List<? extends TypeMirror> superTypes = this.env.getTypeUtils().directSupertypes(declaredType);
            for (TypeMirror typeMirror : superTypes) {
                if (!this.env.getTypeUtils().isSubtype(typeMirror, type)) continue;
                type = typeMirror;
            }
            typeElement = (TypeElement)this.env.getTypeUtils().asElement(type);
            if (type instanceof DeclaredType) {
                arguments = ((DeclaredType)type).getTypeArguments();
            }
        }
        type = this.createType(typeElement, typeCategory, arguments, deep);
        TypeMirror superType = typeElement.getSuperclass();
        TypeElement superTypeElement = null;
        if (superType instanceof DeclaredType) {
            superTypeElement = (TypeElement)((DeclaredType)superType).asElement();
        }
        for (Class<? extends Annotation> entityAnn : this.entityAnnotations) {
            if (typeElement.getAnnotation(entityAnn) == null && (superTypeElement == null || superTypeElement.getAnnotation(entityAnn) == null)) continue;
            EntityType entityType = new EntityType((Type)type);
            this.typeMappings.register((Type)entityType, this.queryTypeFactory.create((Type)entityType));
            return entityType;
        }
        return type;
    }

    private Type createMapType(String simpleName, Iterator<? extends TypeMirror> typeMirrors, boolean deep) {
        Type type;
        TypeElement element;
        Type valueType;
        if (!typeMirrors.hasNext()) {
            return new SimpleType((Type)Types.MAP, new Type[]{this.defaultType, this.defaultType});
        }
        Type keyType = this.getType(typeMirrors.next(), deep);
        if (keyType == null) {
            keyType = this.defaultType;
        }
        if ((valueType = this.getType(typeMirrors.next(), deep)) == null) {
            valueType = this.defaultType;
        } else if (valueType.getParameters().isEmpty() && (element = this.env.getElementUtils().getTypeElement(valueType.getFullName())) != null && !(type = this.getType(element.asType(), deep)).getParameters().isEmpty()) {
            valueType = new SimpleType(valueType, new Type[type.getParameters().size()]);
        }
        return new SimpleType((Type)Types.MAP, new Type[]{keyType, valueType});
    }

    private Type createCollectionType(Type baseType, String simpleName, Iterator<? extends TypeMirror> typeMirrors, boolean deep) {
        Type type;
        TypeElement element;
        if (!typeMirrors.hasNext()) {
            return new SimpleType(baseType, new Type[]{this.defaultType});
        }
        Type componentType = this.getType(typeMirrors.next(), deep);
        if (componentType == null) {
            componentType = this.defaultType;
        } else if (componentType.getParameters().isEmpty() && (element = this.env.getElementUtils().getTypeElement(componentType.getFullName())) != null && !(type = this.getType(element.asType(), deep)).getParameters().isEmpty()) {
            componentType = new SimpleType(componentType, new Type[type.getParameters().size()]);
        }
        return new SimpleType(baseType, new Type[]{componentType});
    }

    @Nullable
    public EntityType getEntityType(TypeMirror typeMirror, boolean deep) {
        List<String> key = this.keyBuilder.visit(typeMirror, true);
        if (this.entityTypeCache.containsKey(key)) {
            EntityType entityType = this.entityTypeCache.get(key);
            if (deep && entityType.getSuperTypes().isEmpty()) {
                for (Type superType : this.getSupertypes(typeMirror, (Type)entityType, deep)) {
                    entityType.addSupertype(new Supertype(superType));
                }
            }
            return entityType;
        }
        return this.createEntityType(typeMirror, key, deep);
    }

    @Nullable
    private EntityType createEntityType(TypeMirror typeMirror, List<String> key, boolean deep) {
        this.entityTypeCache.put(key, null);
        Type value = this.visitor.visit(typeMirror, deep);
        if (value != null) {
            EntityType entityType = null;
            if (value instanceof EntityType) {
                entityType = (EntityType)value;
            } else {
                entityType = new EntityType(value);
                this.typeMappings.register((Type)entityType, this.queryTypeFactory.create((Type)entityType));
            }
            this.entityTypeCache.put(key, entityType);
            if (deep) {
                for (Type superType : this.getSupertypes(typeMirror, value, deep)) {
                    entityType.addSupertype(new Supertype(superType));
                }
            }
            return entityType;
        }
        return null;
    }

    private Type createEnumType(DeclaredType declaredType, TypeElement typeElement, boolean deep) {
        Type enumType = this.createType(typeElement, TypeCategory.ENUM, declaredType.getTypeArguments(), deep);
        for (Class<? extends Annotation> entityAnn : this.entityAnnotations) {
            if (typeElement.getAnnotation(entityAnn) == null) continue;
            EntityType entityType = new EntityType(enumType);
            this.typeMappings.register((Type)entityType, this.queryTypeFactory.create((Type)entityType));
            return entityType;
        }
        return enumType;
    }

    private Type createInterfaceType(DeclaredType declaredType, TypeElement typeElement, boolean deep) {
        for (Class<? extends Annotation> entityAnn : this.entityAnnotations) {
            if (typeElement.getAnnotation(entityAnn) == null) continue;
            return this.createType(typeElement, TypeCategory.ENTITY, declaredType.getTypeArguments(), deep);
        }
        String simpleName = typeElement.getSimpleName().toString();
        Iterator<? extends TypeMirror> i = declaredType.getTypeArguments().iterator();
        if (this.isAssignable(declaredType, this.mapType)) {
            return this.createMapType(simpleName, i, deep);
        }
        if (this.isAssignable(declaredType, this.listType)) {
            return this.createCollectionType((Type)Types.LIST, simpleName, i, deep);
        }
        if (this.isAssignable(declaredType, this.setType)) {
            return this.createCollectionType((Type)Types.SET, simpleName, i, deep);
        }
        if (this.isAssignable(declaredType, this.collectionType)) {
            return this.createCollectionType((Type)Types.COLLECTION, simpleName, i, deep);
        }
        String name = typeElement.getQualifiedName().toString();
        return this.createType(typeElement, TypeCategory.get((String)name), declaredType.getTypeArguments(), deep);
    }

    private Set<Type> getSupertypes(TypeMirror typeMirror, Type type, boolean deep) {
        boolean doubleIndex = this.doubleIndexEntities;
        this.doubleIndexEntities = false;
        Set<Type> superTypes = Collections.emptySet();
        if ((typeMirror = this.normalize(typeMirror)).getKind() == TypeKind.DECLARED) {
            DeclaredType declaredType = (DeclaredType)typeMirror;
            TypeElement e = (TypeElement)declaredType.asElement();
            if (e.getKind() == ElementKind.CLASS) {
                if (e.getSuperclass().getKind() != TypeKind.NONE) {
                    TypeMirror supertype = this.normalize(e.getSuperclass());
                    if (supertype instanceof DeclaredType && ((DeclaredType)supertype).asElement().getAnnotation(QueryExclude.class) != null) {
                        return Collections.emptySet();
                    }
                    Type type2 = this.getType(supertype, deep);
                    if (type2 == null) {
                        System.err.println("Got no type for " + supertype);
                    } else if (!type2.getFullName().startsWith("java")) {
                        superTypes = Collections.singleton(this.getType(supertype, deep));
                    }
                }
            } else {
                superTypes = new HashSet(e.getInterfaces().size());
                for (TypeMirror typeMirror2 : e.getInterfaces()) {
                    Type iface = this.getType(typeMirror2, deep);
                    if (iface.getFullName().startsWith("java")) continue;
                    superTypes.add(iface);
                }
            }
        } else {
            return Collections.emptySet();
        }
        this.doubleIndexEntities = doubleIndex;
        return superTypes;
    }

    private boolean isAssignable(TypeMirror type, TypeMirror iface) {
        return this.env.getTypeUtils().isAssignable(type, iface) || this.env.getTypeUtils().erasure(type).toString().equals(iface.toString());
    }

    private boolean isSubType(TypeMirror type1, TypeMirror clazz) {
        return this.env.getTypeUtils().isSubtype(type1, clazz) || this.env.getTypeUtils().directSupertypes(type1).contains(clazz);
    }

    private TypeMirror normalize(TypeMirror type) {
        WildcardType wildcard;
        if (type.getKind() == TypeKind.TYPEVAR) {
            TypeVariable typeVar = (TypeVariable)type;
            if (typeVar.getUpperBound() != null) {
                return typeVar.getUpperBound();
            }
        } else if (type.getKind() == TypeKind.WILDCARD && (wildcard = (WildcardType)type).getExtendsBound() != null) {
            return wildcard.getExtendsBound();
        }
        return type;
    }

    public void extendTypes() {
        block0: for (EntityType entityType : this.entityTypeCache.values()) {
            if (!entityType.getProperties().isEmpty()) continue;
            for (Map.Entry<List<String>, EntityType> entry : this.entityTypeCache.entrySet()) {
                if (!entry.getKey().get(0).equals(entityType.getFullName()) || entry.getValue().getProperties().isEmpty()) continue;
                for (Property property : entry.getValue().getProperties()) {
                    entityType.addProperty(property);
                }
                continue block0;
            }
        }
    }
}

