/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.codegen;

import com.google.common.collect.Lists;
import com.google.common.primitives.Primitives;
import com.mysema.codegen.model.ClassType;
import com.mysema.codegen.model.SimpleType;
import com.mysema.codegen.model.TypeCategory;
import com.mysema.codegen.model.TypeExtends;
import com.mysema.codegen.model.TypeSuper;
import com.mysema.codegen.model.Types;
import com.mysema.query.codegen.EntityType;
import com.mysema.query.codegen.ParameterizedTypeImpl;
import com.mysema.query.codegen.Property;
import com.mysema.util.ReflectionUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class TypeFactory {
    private static final com.mysema.codegen.model.Type ANY = new TypeExtends((com.mysema.codegen.model.Type)Types.OBJECT);
    private final Map<List<Type>, com.mysema.codegen.model.Type> cache = new HashMap<List<Type>, com.mysema.codegen.model.Type>();
    private final List<Class<? extends Annotation>> entityAnnotations;
    private final Set<Class<?>> embeddableTypes = new HashSet();
    private boolean unknownAsEntity = false;

    public TypeFactory() {
        this(Lists.newArrayList());
    }

    public TypeFactory(List<Class<? extends Annotation>> entityAnnotations) {
        this.entityAnnotations = entityAnnotations;
    }

    public EntityType getEntityType(Class<?> cl) {
        Type generic = cl;
        if (cl.getTypeParameters().length > 0) {
            generic = new ParameterizedTypeImpl(cl, cl.getTypeParameters());
        }
        return (EntityType)this.get(true, cl, generic);
    }

    public com.mysema.codegen.model.Type get(Class<?> cl) {
        return this.get(this.isEntityClass(cl), cl, cl);
    }

    public com.mysema.codegen.model.Type get(Class<?> cl, Type genericType) {
        return this.get(this.isEntityClass(cl), cl, genericType);
    }

    public com.mysema.codegen.model.Type get(boolean entity, Class<?> cl, Type genericType) {
        List<Type> key = Arrays.asList(cl, genericType);
        if (this.cache.containsKey(key)) {
            Object value = this.cache.get(key);
            if (entity && !(value instanceof EntityType)) {
                value = new EntityType((com.mysema.codegen.model.Type)value);
                this.cache.put(key, (com.mysema.codegen.model.Type)value);
            }
            return value;
        }
        com.mysema.codegen.model.Type value = this.create(entity, cl, genericType, key);
        this.cache.put(key, value);
        return value;
    }

    private com.mysema.codegen.model.Type create(boolean entity, Class<?> cl, Type genericType, List<Type> key) {
        Object value;
        if (cl.isPrimitive()) {
            cl = Primitives.wrap(cl);
        }
        com.mysema.codegen.model.Type[] tempParams = (com.mysema.codegen.model.Type[])Array.newInstance(com.mysema.codegen.model.Type.class, ReflectionUtils.getTypeParameterCount((Type)genericType));
        this.cache.put(key, (com.mysema.codegen.model.Type)new ClassType(cl, tempParams));
        com.mysema.codegen.model.Type[] parameters = this.getParameters(cl, genericType);
        if (cl.isArray()) {
            com.mysema.codegen.model.Type componentType = this.get(cl.getComponentType());
            if (cl.getComponentType().isPrimitive()) {
                componentType = (com.mysema.codegen.model.Type)Types.PRIMITIVES.get(componentType);
            }
            value = componentType.asArrayType();
        } else {
            value = cl.isEnum() ? new ClassType(TypeCategory.ENUM, cl, new com.mysema.codegen.model.Type[0]) : (Number.class.isAssignableFrom(cl) && Comparable.class.isAssignableFrom(cl) ? new ClassType(TypeCategory.NUMERIC, cl, parameters) : (entity ? this.createOther(cl, entity, parameters) : (Map.class.isAssignableFrom(cl) ? new SimpleType((com.mysema.codegen.model.Type)Types.MAP, new com.mysema.codegen.model.Type[]{parameters[0], this.asGeneric(parameters[1])}) : (List.class.isAssignableFrom(cl) ? new SimpleType((com.mysema.codegen.model.Type)Types.LIST, new com.mysema.codegen.model.Type[]{this.asGeneric(parameters[0])}) : (Set.class.isAssignableFrom(cl) ? new SimpleType((com.mysema.codegen.model.Type)Types.SET, new com.mysema.codegen.model.Type[]{this.asGeneric(parameters[0])}) : (Collection.class.isAssignableFrom(cl) ? new SimpleType((com.mysema.codegen.model.Type)Types.COLLECTION, new com.mysema.codegen.model.Type[]{this.asGeneric(parameters[0])}) : this.createOther(cl, entity, parameters)))))));
        }
        if (genericType instanceof TypeVariable) {
            TypeVariable tv = (TypeVariable)genericType;
            value = tv.getBounds().length == 1 && tv.getBounds()[0].equals(Object.class) ? new TypeSuper(tv.getName(), (com.mysema.codegen.model.Type)value) : new TypeExtends(tv.getName(), (com.mysema.codegen.model.Type)value);
        }
        if (entity && !(value instanceof EntityType)) {
            value = new EntityType((com.mysema.codegen.model.Type)value);
        }
        return value;
    }

    private com.mysema.codegen.model.Type asGeneric(com.mysema.codegen.model.Type type) {
        int count;
        if (type.getParameters().size() == 0 && (count = type.getJavaClass().getTypeParameters().length) > 0) {
            return new SimpleType(type, new com.mysema.codegen.model.Type[count]);
        }
        return type;
    }

    private com.mysema.codegen.model.Type createOther(Class<?> cl, boolean entity, com.mysema.codegen.model.Type[] parameters) {
        TypeCategory typeCategory = TypeCategory.get((String)cl.getName());
        if (!typeCategory.isSubCategoryOf(TypeCategory.COMPARABLE) && Comparable.class.isAssignableFrom(cl) && !cl.equals(Comparable.class)) {
            typeCategory = TypeCategory.COMPARABLE;
        } else if (this.embeddableTypes.contains(cl)) {
            typeCategory = TypeCategory.CUSTOM;
        } else if (typeCategory == TypeCategory.SIMPLE && entity) {
            typeCategory = TypeCategory.ENTITY;
        } else if (this.unknownAsEntity && typeCategory == TypeCategory.SIMPLE && !cl.getName().startsWith("java")) {
            typeCategory = TypeCategory.CUSTOM;
        }
        return new ClassType(typeCategory, cl, parameters);
    }

    private com.mysema.codegen.model.Type[] getParameters(Class<?> cl, Type genericType) {
        int parameterCount = ReflectionUtils.getTypeParameterCount((Type)genericType);
        if (parameterCount > 0) {
            return this.getGenericParameters(cl, genericType, parameterCount);
        }
        if (Map.class.isAssignableFrom(cl)) {
            return new com.mysema.codegen.model.Type[]{Types.OBJECT, Types.OBJECT};
        }
        if (Collection.class.isAssignableFrom(cl)) {
            return new com.mysema.codegen.model.Type[]{Types.OBJECT};
        }
        return new com.mysema.codegen.model.Type[0];
    }

    private com.mysema.codegen.model.Type[] getGenericParameters(Class<?> cl, Type genericType, int parameterCount) {
        com.mysema.codegen.model.Type[] types = new com.mysema.codegen.model.Type[parameterCount];
        for (int i = 0; i < types.length; ++i) {
            types[i] = this.getGenericParameter(cl, genericType, i);
        }
        return types;
    }

    private com.mysema.codegen.model.Type getGenericParameter(Class<?> cl, Type genericType, int i) {
        Type parameter = ReflectionUtils.getTypeParameter((Type)genericType, (int)i);
        if (parameter instanceof TypeVariable) {
            TypeVariable variable = (TypeVariable)parameter;
            com.mysema.codegen.model.Type rv = this.get(ReflectionUtils.getTypeParameterAsClass((Type)genericType, (int)i), parameter);
            return new TypeExtends(variable.getName(), rv);
        }
        if (parameter instanceof WildcardType && ((WildcardType)parameter).getUpperBounds()[0].equals(Object.class) && ((WildcardType)parameter).getLowerBounds().length == 0) {
            return ANY;
        }
        com.mysema.codegen.model.Type rv = this.get(ReflectionUtils.getTypeParameterAsClass((Type)genericType, (int)i), parameter);
        if (parameter instanceof WildcardType) {
            rv = new TypeExtends(rv);
        }
        return rv;
    }

    private boolean isEntityClass(Class<?> cl) {
        for (Class<? extends Annotation> clazz : this.entityAnnotations) {
            if (cl.getAnnotation(clazz) == null) continue;
            return true;
        }
        return this.embeddableTypes.contains(cl);
    }

    public void extendTypes() {
        for (Map.Entry<List<Type>, com.mysema.codegen.model.Type> entry : this.cache.entrySet()) {
            EntityType entityType;
            if (!(entry.getValue() instanceof EntityType) || !(entityType = (EntityType)entry.getValue()).getProperties().isEmpty()) continue;
            for (com.mysema.codegen.model.Type type : this.cache.values()) {
                if (!type.getFullName().equals(entityType.getFullName()) || !(type instanceof EntityType)) continue;
                EntityType base = (EntityType)type;
                for (Property property : base.getProperties()) {
                    entityType.addProperty(property);
                }
            }
        }
    }

    public void setUnknownAsEntity(boolean unknownAsEntity) {
        this.unknownAsEntity = unknownAsEntity;
    }

    public void addEmbeddableType(Class<?> cl) {
        this.embeddableTypes.add(cl);
    }
}

