/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.collections;

import com.mysema.util.ReflectionUtils;
import java.lang.reflect.Field;
import java.util.Calendar;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public final class ColQueryFunctions {
    public static <A extends Comparable<? super A>> boolean between(A a, A b, A c) {
        return a.compareTo(b) >= 0 && a.compareTo(c) <= 0;
    }

    public static double cot(double x) {
        return Math.cos(x) / Math.sin(x);
    }

    public static double coth(double x) {
        return Math.cosh(x) / Math.sinh(x);
    }

    public static double degrees(double x) {
        return x * 180.0 / Math.PI;
    }

    public static double radians(double x) {
        return x * Math.PI / 180.0;
    }

    public static double log(double x, int y) {
        return Math.log(x) / Math.log(y);
    }

    @Nullable
    public static <T> T coalesce(T ... args) {
        for (T arg : args) {
            if (arg == null) continue;
            return arg;
        }
        return null;
    }

    public static int getDayOfMonth(Date date) {
        return ColQueryFunctions.getField(date, 5);
    }

    public static int getDayOfWeek(Date date) {
        return ColQueryFunctions.getField(date, 7);
    }

    public static int getDayOfYear(Date date) {
        return ColQueryFunctions.getField(date, 6);
    }

    private static int getField(Date date, int field) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(field);
    }

    public static int getHour(Date date) {
        return ColQueryFunctions.getField(date, 11);
    }

    public static int getMilliSecond(Date date) {
        return ColQueryFunctions.getField(date, 14);
    }

    public static int getMinute(Date date) {
        return ColQueryFunctions.getField(date, 12);
    }

    public static int getMonth(Date date) {
        return ColQueryFunctions.getField(date, 2) + 1;
    }

    public static int getSecond(Date date) {
        return ColQueryFunctions.getField(date, 13);
    }

    public static int getWeek(Date date) {
        return ColQueryFunctions.getField(date, 3);
    }

    public static int getYear(Date date) {
        return ColQueryFunctions.getField(date, 1);
    }

    public static int getYearMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(1) * 100 + cal.get(2) + 1;
    }

    public static boolean like(String str, String like) {
        if (like.contains("%") || like.contains("_")) {
            Matcher m = Pattern.compile("[^\\%_]+").matcher(like);
            StringBuffer sb = new StringBuffer();
            while (m.find()) {
                m.appendReplacement(sb, Matcher.quoteReplacement(Pattern.quote(m.group())));
            }
            m.appendTail(sb);
            return str.matches(sb.toString().replace("%", ".*").replace("_", "."));
        }
        return str.equals(like);
    }

    public static boolean like(String str, String like, char escape) {
        return ColQueryFunctions.like(str, like);
    }

    public static <T> T get(Object parent, String f) {
        try {
            Field field = ReflectionUtils.getFieldOrNull(parent.getClass(), (String)f);
            if (field != null) {
                field.setAccessible(true);
                return (T)field.get(parent);
            }
            throw new IllegalArgumentException("No field " + f + " for " + parent.getClass());
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    private ColQueryFunctions() {
    }
}

