/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.jpa;

import com.mysema.query.QueryMetadata;
import com.mysema.query.jpa.JPQLQueryMixin;
import com.mysema.query.jpa.JPQLSerializer;
import com.mysema.query.jpa.JPQLTemplates;
import com.mysema.query.support.ProjectableQuery;
import com.mysema.query.types.CollectionExpression;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.MapExpression;
import com.mysema.query.types.Path;
import com.mysema.query.types.Predicate;
import com.mysema.query.types.template.NumberTemplate;
import java.util.Map;

public abstract class JPQLQueryBase<Q extends JPQLQueryBase<Q>>
extends ProjectableQuery<Q> {
    private Map<Object, String> constants;
    private final JPQLQueryMixin<Q> queryMixin;
    private final JPQLTemplates templates;

    protected JPQLTemplates getTemplates() {
        return this.templates;
    }

    protected JPQLQueryMixin<Q> getQueryMixin() {
        return this.queryMixin;
    }

    public JPQLQueryBase(QueryMetadata md, JPQLTemplates templates) {
        super(new JPQLQueryMixin(md));
        ((ProjectableQuery)this).queryMixin.setSelf((Object)this);
        this.queryMixin = (JPQLQueryMixin)((ProjectableQuery)this).queryMixin;
        this.templates = templates;
    }

    protected String buildQueryString(boolean forCountRow) {
        if (this.queryMixin.getMetadata().getJoins().isEmpty()) {
            throw new IllegalArgumentException("No joins given");
        }
        JPQLSerializer serializer = new JPQLSerializer(this.templates);
        serializer.serialize(this.queryMixin.getMetadata(), forCountRow, null);
        this.constants = serializer.getConstantToLabel();
        return serializer.toString();
    }

    protected void reset() {
        this.queryMixin.getMetadata().reset();
    }

    public boolean exists() {
        return ((JPQLQueryBase)this.limit(1L)).uniqueResult((Expression)NumberTemplate.one) != null;
    }

    public Q fetch() {
        return (Q)((Object)((JPQLQueryBase)((Object)this.queryMixin.fetch())));
    }

    public Q fetchAll() {
        return (Q)((Object)((JPQLQueryBase)((Object)this.queryMixin.fetchAll())));
    }

    public Q from(EntityPath<?> ... args) {
        return (Q)((Object)((JPQLQueryBase)((Object)this.queryMixin.from(args))));
    }

    public <P> Q fullJoin(CollectionExpression<?, P> target) {
        return (Q)((Object)((JPQLQueryBase)((Object)this.queryMixin.fullJoin(target))));
    }

    public <P> Q fullJoin(CollectionExpression<?, P> target, Path<P> alias) {
        return (Q)((Object)((JPQLQueryBase)((Object)this.queryMixin.fullJoin(target, alias))));
    }

    public <P> Q fullJoin(EntityPath<P> target) {
        return (Q)((Object)((JPQLQueryBase)((Object)this.queryMixin.fullJoin(target))));
    }

    public <P> Q fullJoin(EntityPath<P> target, EntityPath<P> alias) {
        return (Q)((Object)((JPQLQueryBase)((Object)this.queryMixin.fullJoin(target, alias))));
    }

    public <P> Q fullJoin(MapExpression<?, P> target) {
        return (Q)((Object)((JPQLQueryBase)((Object)this.queryMixin.fullJoin(target))));
    }

    public <P> Q fullJoin(MapExpression<?, P> target, Path<P> alias) {
        return (Q)((Object)((JPQLQueryBase)((Object)this.queryMixin.fullJoin(target, alias))));
    }

    protected Map<Object, String> getConstants() {
        return this.constants;
    }

    public <P> Q innerJoin(CollectionExpression<?, P> target) {
        return (Q)((Object)((JPQLQueryBase)((Object)this.queryMixin.innerJoin(target))));
    }

    public <P> Q innerJoin(CollectionExpression<?, P> target, Path<P> alias) {
        return (Q)((Object)((JPQLQueryBase)((Object)this.queryMixin.innerJoin(target, alias))));
    }

    public <P> Q innerJoin(EntityPath<P> target) {
        return (Q)((Object)((JPQLQueryBase)((Object)this.queryMixin.innerJoin(target))));
    }

    public <P> Q innerJoin(EntityPath<P> target, EntityPath<P> alias) {
        return (Q)((Object)((JPQLQueryBase)((Object)this.queryMixin.innerJoin(target, alias))));
    }

    public <P> Q innerJoin(MapExpression<?, P> target) {
        return (Q)((Object)((JPQLQueryBase)((Object)this.queryMixin.innerJoin(target))));
    }

    public <P> Q innerJoin(MapExpression<?, P> target, Path<P> alias) {
        return (Q)((Object)((JPQLQueryBase)((Object)this.queryMixin.innerJoin(target, alias))));
    }

    public <P> Q join(CollectionExpression<?, P> target) {
        return (Q)((Object)((JPQLQueryBase)((Object)this.queryMixin.innerJoin(target))));
    }

    public <P> Q join(CollectionExpression<?, P> target, Path<P> alias) {
        return (Q)((Object)((JPQLQueryBase)((Object)this.queryMixin.innerJoin(target, alias))));
    }

    public <P> Q join(EntityPath<P> target) {
        return (Q)((Object)((JPQLQueryBase)((Object)this.queryMixin.innerJoin(target))));
    }

    public <P> Q join(EntityPath<P> target, EntityPath<P> alias) {
        return (Q)((Object)((JPQLQueryBase)((Object)this.queryMixin.innerJoin(target, alias))));
    }

    public <P> Q join(MapExpression<?, P> target) {
        return (Q)((Object)((JPQLQueryBase)((Object)this.queryMixin.join(target))));
    }

    public <P> Q join(MapExpression<?, P> target, Path<P> alias) {
        return (Q)((Object)((JPQLQueryBase)((Object)this.queryMixin.join(target, alias))));
    }

    public <P> Q leftJoin(CollectionExpression<?, P> target) {
        return (Q)((Object)((JPQLQueryBase)((Object)this.queryMixin.leftJoin(target))));
    }

    public <P> Q leftJoin(CollectionExpression<?, P> target, Path<P> alias) {
        return (Q)((Object)((JPQLQueryBase)((Object)this.queryMixin.leftJoin(target, alias))));
    }

    public <P> Q leftJoin(EntityPath<P> target) {
        return (Q)((Object)((JPQLQueryBase)((Object)this.queryMixin.leftJoin(target))));
    }

    public <P> Q leftJoin(EntityPath<P> target, EntityPath<P> alias) {
        return (Q)((Object)((JPQLQueryBase)((Object)this.queryMixin.leftJoin(target, alias))));
    }

    public <P> Q leftJoin(MapExpression<?, P> target) {
        return (Q)((Object)((JPQLQueryBase)((Object)this.queryMixin.leftJoin(target))));
    }

    public <P> Q leftJoin(MapExpression<?, P> target, Path<P> alias) {
        return (Q)((Object)((JPQLQueryBase)((Object)this.queryMixin.leftJoin(target, alias))));
    }

    public Q with(Predicate ... conditions) {
        return (Q)((Object)((JPQLQueryBase)((Object)this.queryMixin.with(conditions))));
    }

    protected void setConstants(Map<Object, String> constants) {
        this.constants = constants;
    }

    protected String toCountRowsString() {
        return this.buildQueryString(true);
    }

    protected String toQueryString() {
        return this.buildQueryString(false);
    }

    public String toString() {
        return this.buildQueryString(false).trim();
    }

    public QueryMetadata getMetadata() {
        return this.queryMixin.getMetadata();
    }
}

