/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.jpa;

import com.mysema.query.JoinExpression;
import com.mysema.query.JoinType;
import com.mysema.query.QueryMetadata;
import com.mysema.query.jpa.JPQLQueryMixin;
import com.mysema.query.jpa.JPQLTemplates;
import com.mysema.query.support.SerializerBase;
import com.mysema.query.types.Constant;
import com.mysema.query.types.ConstantImpl;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.ExpressionUtils;
import com.mysema.query.types.FactoryExpression;
import com.mysema.query.types.Operator;
import com.mysema.query.types.Ops;
import com.mysema.query.types.OrderSpecifier;
import com.mysema.query.types.ParamExpression;
import com.mysema.query.types.Path;
import com.mysema.query.types.PathType;
import com.mysema.query.types.Predicate;
import com.mysema.query.types.SubQueryExpression;
import com.mysema.query.types.Templates;
import com.mysema.util.MathUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.persistence.DiscriminatorValue;

public class JPQLSerializer
extends SerializerBase<JPQLSerializer> {
    private static final Set<Operator<?>> NUMERIC = new HashSet<Operator>(Arrays.asList(Ops.ADD, Ops.SUB, Ops.MULT, Ops.DIV, Ops.LT, Ops.LOE, Ops.GT, Ops.GOE, Ops.BETWEEN, Ops.BEFORE, Ops.AFTER, Ops.BOE, Ops.AOE));
    private static final String SELECT_COUNT_DISTINCT = "select count(distinct ";
    private static final String COMMA = ", ";
    private static final String DELETE = "delete ";
    private static final String FROM = "from ";
    private static final String GROUP_BY = "\ngroup by ";
    private static final String HAVING = "\nhaving ";
    private static final String ORDER_BY = "\norder by ";
    private static final String SELECT = "select ";
    private static final String SELECT_COUNT = "select count(";
    private static final String SELECT_DISTINCT = "select distinct ";
    private static final String SET = "\nset ";
    private static final String UPDATE = "update ";
    private static final String WHERE = "\nwhere ";
    private static final String WITH = " with ";
    private static final Map<JoinType, String> joinTypes = new HashMap<JoinType, String>();
    private final JPQLTemplates templates;
    private boolean wrapElements = false;

    public JPQLSerializer(JPQLTemplates templates) {
        super((Templates)templates);
        this.templates = templates;
    }

    private void handleJoinTarget(JoinExpression je) {
        EntityPath pe;
        if (je.getTarget() instanceof EntityPath && (pe = (EntityPath)je.getTarget()).getMetadata().getParent() == null) {
            if (pe.getType().getPackage() != null) {
                String pn = pe.getType().getPackage().getName();
                String typeName = pe.getType().getName().substring(pn.length() + 1);
                this.append(new String[]{typeName});
            } else {
                this.append(new String[]{pe.getType().getName()});
            }
            this.append(new String[]{" "});
        }
        this.handle(je.getTarget());
    }

    public void serialize(QueryMetadata metadata, boolean forCountRow, @Nullable String projection) {
        List select = metadata.getProjection();
        List joins = metadata.getJoins();
        Predicate where = metadata.getWhere();
        List groupBy = metadata.getGroupBy();
        Predicate having = metadata.getHaving();
        List orderBy = metadata.getOrderBy();
        if (projection != null) {
            ((JPQLSerializer)((JPQLSerializer)this.append(new String[]{SELECT})).append(new String[]{projection})).append(new String[]{"\n"});
        } else if (forCountRow) {
            if (!metadata.isDistinct()) {
                this.append(new String[]{SELECT_COUNT});
            } else {
                this.append(new String[]{SELECT_COUNT_DISTINCT});
            }
            if (!select.isEmpty()) {
                this.handle(COMMA, select);
            } else {
                this.handle(((JoinExpression)joins.get(0)).getTarget());
            }
            this.append(new String[]{")\n"});
        } else if (!select.isEmpty()) {
            if (!metadata.isDistinct()) {
                this.append(new String[]{SELECT});
            } else {
                this.append(new String[]{SELECT_DISTINCT});
            }
            ((JPQLSerializer)this.handle(COMMA, select)).append(new String[]{"\n"});
        }
        this.append(new String[]{FROM});
        this.serializeSources(forCountRow, joins);
        if (where != null) {
            ((JPQLSerializer)this.append(new String[]{WHERE})).handle((Expression)where);
        }
        if (!groupBy.isEmpty()) {
            ((JPQLSerializer)this.append(new String[]{GROUP_BY})).handle(COMMA, groupBy);
        }
        if (having != null) {
            ((JPQLSerializer)this.append(new String[]{HAVING})).handle((Expression)having);
        }
        if (!orderBy.isEmpty() && !forCountRow) {
            this.append(new String[]{ORDER_BY});
            boolean first = true;
            for (OrderSpecifier os : orderBy) {
                if (!first) {
                    this.append(new String[]{COMMA});
                }
                this.handle(os.getTarget());
                this.append(new String[]{" " + os.getOrder().toString().toLowerCase(Locale.ENGLISH)});
                first = false;
            }
        }
    }

    public void serializeForDelete(QueryMetadata md) {
        this.append(new String[]{DELETE});
        this.handleJoinTarget((JoinExpression)md.getJoins().get(0));
        if (md.getWhere() != null) {
            ((JPQLSerializer)this.append(new String[]{WHERE})).handle((Expression)md.getWhere());
        }
    }

    public void serializeForUpdate(QueryMetadata md) {
        this.append(new String[]{UPDATE});
        this.handleJoinTarget((JoinExpression)md.getJoins().get(0));
        this.append(new String[]{SET});
        this.handle(COMMA, md.getProjection());
        if (md.getWhere() != null) {
            ((JPQLSerializer)this.append(new String[]{WHERE})).handle((Expression)md.getWhere());
        }
    }

    private void serializeSources(boolean forCountRow, List<JoinExpression> joins) {
        for (int i = 0; i < joins.size(); ++i) {
            JoinExpression je = joins.get(i);
            if (i > 0) {
                this.append(new String[]{joinTypes.get(je.getType())});
            }
            if (je.hasFlag(JPQLQueryMixin.FETCH) && !forCountRow) {
                this.handle(JPQLQueryMixin.FETCH);
            }
            this.handleJoinTarget(je);
            if (je.hasFlag(JPQLQueryMixin.FETCH_ALL_PROPERTIES) && !forCountRow) {
                this.handle(JPQLQueryMixin.FETCH_ALL_PROPERTIES);
            }
            if (je.getCondition() == null) continue;
            ((JPQLSerializer)this.append(new String[]{WITH})).handle((Expression)je.getCondition());
        }
    }

    public Void visit(Constant<?> expr, Void context) {
        boolean wrap = this.templates.wrapConstant(expr);
        if (wrap) {
            this.append(new String[]{"("});
        }
        this.append(new String[]{":"});
        if (!this.getConstantToLabel().containsKey(expr.getConstant())) {
            String constLabel = this.getConstantPrefix() + (this.getConstantToLabel().size() + 1);
            this.getConstantToLabel().put(expr.getConstant(), constLabel);
            this.append(new String[]{constLabel});
        } else {
            this.append(new String[]{(String)this.getConstantToLabel().get(expr.getConstant())});
        }
        if (wrap) {
            this.append(new String[]{")"});
        }
        return null;
    }

    public Void visit(ParamExpression<?> param, Void context) {
        this.append(new String[]{":"});
        super.visit(param, context);
        return null;
    }

    public Void visit(SubQueryExpression<?> query, Void context) {
        this.append(new String[]{"("});
        this.serialize(query.getMetadata(), false, null);
        this.append(new String[]{")"});
        return null;
    }

    public Void visit(Path<?> expr, Void context) {
        boolean wrap;
        boolean bl = wrap = this.wrapElements && (Collection.class.isAssignableFrom(expr.getType()) || Map.class.isAssignableFrom(expr.getType())) && expr.getMetadata().getPathType().equals((Object)PathType.PROPERTY);
        if (wrap) {
            this.append(new String[]{"elements("});
        }
        super.visit(expr, context);
        if (wrap) {
            this.append(new String[]{")"});
        }
        return null;
    }

    public Void visit(FactoryExpression<?> expr, Void context) {
        super.visit(expr, context);
        return null;
    }

    protected void visitOperation(Class<?> type, Operator<?> operator, List<Expression<?>> args) {
        boolean old = this.wrapElements;
        this.wrapElements = this.templates.wrapElements(operator);
        if (operator.equals((Object)Ops.IN)) {
            if (args.get(1) instanceof Path) {
                super.visitOperation(type, JPQLTemplates.MEMBER_OF, args);
            } else {
                super.visitOperation(type, operator, args);
            }
        } else if (operator.equals((Object)Ops.INSTANCE_OF)) {
            if (this.templates.isTypeAsString()) {
                ArrayList newArgs = new ArrayList(args);
                Class cl = (Class)((Constant)newArgs.get(1)).getConstant();
                if (cl.getAnnotation(DiscriminatorValue.class) != null) {
                    newArgs.set(1, (Expression<?>)ConstantImpl.create((String)cl.getAnnotation(DiscriminatorValue.class).value()));
                } else {
                    newArgs.set(1, (Expression<?>)ConstantImpl.create((String)cl.getName()));
                }
                super.visitOperation(type, operator, newArgs);
            } else {
                super.visitOperation(type, operator, args);
            }
        } else if (operator.equals((Object)Ops.NUMCAST)) {
            Class targetType = (Class)((Constant)args.get(1)).getConstant();
            String typeName = targetType.getSimpleName().toLowerCase(Locale.ENGLISH);
            this.visitOperation(targetType, JPQLTemplates.CAST, Arrays.asList(args.get(0), ConstantImpl.create((String)typeName)));
        } else if (operator.equals((Object)Ops.EXISTS) && args.get(0) instanceof SubQueryExpression) {
            SubQueryExpression subQuery = (SubQueryExpression)args.get(0);
            this.append(new String[]{"exists ("});
            this.serialize(subQuery.getMetadata(), false, this.templates.getExistsProjection());
            this.append(new String[]{")"});
        } else if (operator.equals((Object)Ops.MATCHES) || operator.equals((Object)Ops.MATCHES_IC)) {
            super.visitOperation(type, Ops.LIKE, Arrays.asList(args.get(0), ExpressionUtils.regexToLike(args.get(1))));
        } else if (NUMERIC.contains(operator)) {
            super.visitOperation(type, operator, this.normalizeNumericArgs(args));
        } else {
            super.visitOperation(type, operator, args);
        }
        this.wrapElements = old;
    }

    private List<Expression<?>> normalizeNumericArgs(List<Expression<?>> args) {
        boolean hasConstants = false;
        Class numType = null;
        for (Expression<?> arg : args) {
            if (!Number.class.isAssignableFrom(arg.getType())) continue;
            if (arg instanceof Constant) {
                hasConstants = true;
                continue;
            }
            numType = arg.getType();
        }
        if (hasConstants && numType != null) {
            ArrayList newArgs = new ArrayList(args.size());
            for (Expression<?> arg : args) {
                if (arg instanceof Constant && Number.class.isAssignableFrom(arg.getType()) && !arg.getType().equals(numType)) {
                    Number number = (Number)((Constant)arg).getConstant();
                    newArgs.add((Expression<?>)new ConstantImpl((Object)MathUtils.cast((Number)number, (Class)numType)));
                    continue;
                }
                newArgs.add(arg);
            }
            return newArgs;
        }
        return args;
    }

    static {
        joinTypes.put(JoinType.DEFAULT, COMMA);
        joinTypes.put(JoinType.FULLJOIN, "\n  full join ");
        joinTypes.put(JoinType.INNERJOIN, "\n  inner join ");
        joinTypes.put(JoinType.JOIN, "\n  join ");
        joinTypes.put(JoinType.LEFTJOIN, "\n  left join ");
    }
}

