/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.jpa.sql;

import com.mysema.commons.lang.CloseableIterator;
import com.mysema.commons.lang.IteratorAdapter;
import com.mysema.query.DefaultQueryMetadata;
import com.mysema.query.NonUniqueResultException;
import com.mysema.query.QueryMetadata;
import com.mysema.query.QueryModifiers;
import com.mysema.query.SearchResults;
import com.mysema.query.jpa.AbstractSQLQuery;
import com.mysema.query.jpa.HibernateSQLSerializer;
import com.mysema.query.jpa.impl.DefaultSessionHolder;
import com.mysema.query.jpa.impl.JPASessionHolder;
import com.mysema.query.jpa.impl.JPAUtil;
import com.mysema.query.sql.SQLCommonQuery;
import com.mysema.query.sql.SQLTemplates;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JPASQLQuery
extends AbstractSQLQuery<JPASQLQuery>
implements SQLCommonQuery<JPASQLQuery> {
    private static final Logger logger = LoggerFactory.getLogger(JPASQLQuery.class);
    @Nullable
    private Map<Object, String> constants;
    private final JPASessionHolder session;
    private final SQLTemplates sqlTemplates;

    public JPASQLQuery(EntityManager entityManager, SQLTemplates sqlTemplates) {
        this(new DefaultSessionHolder(entityManager), sqlTemplates, (QueryMetadata)new DefaultQueryMetadata());
    }

    protected JPASQLQuery(JPASessionHolder session, SQLTemplates sqlTemplates, QueryMetadata metadata) {
        super(metadata);
        this.session = session;
        this.sqlTemplates = sqlTemplates;
    }

    private String buildQueryString(boolean forCountRow) {
        if (this.queryMixin.getMetadata().getJoins().isEmpty()) {
            throw new IllegalArgumentException("No joins given");
        }
        HibernateSQLSerializer serializer = new HibernateSQLSerializer(this.sqlTemplates);
        serializer.serialize(this.queryMixin.getMetadata(), forCountRow);
        this.constants = serializer.getConstantToLabel();
        return serializer.toString();
    }

    public JPASQLQuery clone(EntityManager entityManager) {
        return new JPASQLQuery(new DefaultSessionHolder(entityManager), this.sqlTemplates, this.getMetadata().clone());
    }

    public Query createQuery(Expression<?> ... args) {
        this.queryMixin.addToProjection(args);
        return this.createQuery(this.toQueryString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Query createQuery(String queryString) {
        Query query;
        this.logQuery(queryString);
        List projection = this.queryMixin.getMetadata().getProjection();
        if (projection.get(0) instanceof EntityPath) {
            if (projection.size() != 1) throw new IllegalArgumentException("Only single element entity projections are supported");
            query = this.session.createSQLQuery(queryString, ((Expression)projection.get(0)).getType());
        } else {
            query = this.session.createSQLQuery(queryString);
        }
        JPAUtil.setConstants(query, this.constants, this.queryMixin.getMetadata().getParams());
        return query;
    }

    public List<Object[]> list(Expression<?>[] args) {
        Query query = this.createQuery(args);
        this.reset();
        return query.getResultList();
    }

    public <RT> List<RT> list(Expression<RT> projection) {
        Query query = this.createQuery(projection);
        this.reset();
        return query.getResultList();
    }

    public CloseableIterator<Object[]> iterate(Expression<?>[] args) {
        return new IteratorAdapter(this.list(args).iterator());
    }

    public <RT> CloseableIterator<RT> iterate(Expression<RT> projection) {
        return new IteratorAdapter(this.list(projection).iterator());
    }

    public <RT> SearchResults<RT> listResults(Expression<RT> projection) {
        this.queryMixin.addToProjection(new Expression[]{projection});
        Query query = this.createQuery(this.toCountRowsString());
        long total = ((Integer)query.getSingleResult()).longValue();
        if (total > 0L) {
            QueryModifiers modifiers = this.queryMixin.getMetadata().getModifiers();
            String queryString = this.toQueryString();
            query = this.createQuery(queryString);
            List list = query.getResultList();
            this.reset();
            return new SearchResults(list, modifiers, total);
        }
        this.reset();
        return SearchResults.emptyResults();
    }

    protected void logQuery(String queryString) {
        if (logger.isDebugEnabled()) {
            logger.debug(queryString.replace('\n', ' '));
        }
    }

    protected void reset() {
        this.queryMixin.getMetadata().reset();
        this.constants = null;
    }

    protected String toCountRowsString() {
        return this.buildQueryString(true);
    }

    protected String toQueryString() {
        return this.buildQueryString(false);
    }

    public <RT> RT uniqueResult(Expression<RT> expr) {
        Query query = this.createQuery(expr);
        this.reset();
        try {
            return (RT)query.getSingleResult();
        }
        catch (NoResultException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            return null;
        }
        catch (javax.persistence.NonUniqueResultException e) {
            throw new NonUniqueResultException();
        }
    }
}

