/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.jpa.hibernate;

import com.mysema.query.DefaultQueryMetadata;
import com.mysema.query.JoinType;
import com.mysema.query.QueryMetadata;
import com.mysema.query.dml.UpdateClause;
import com.mysema.query.jpa.HQLTemplates;
import com.mysema.query.jpa.JPQLSerializer;
import com.mysema.query.jpa.JPQLTemplates;
import com.mysema.query.jpa.hibernate.DefaultSessionHolder;
import com.mysema.query.jpa.hibernate.HibernateUtil;
import com.mysema.query.jpa.hibernate.SessionHolder;
import com.mysema.query.jpa.hibernate.StatelessSessionHolder;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.ExpressionUtils;
import com.mysema.query.types.NullExpression;
import com.mysema.query.types.Path;
import com.mysema.query.types.Predicate;
import java.util.List;
import java.util.Map;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.StatelessSession;

public class HibernateUpdateClause
implements UpdateClause<HibernateUpdateClause> {
    private final QueryMetadata metadata = new DefaultQueryMetadata();
    private final SessionHolder session;
    private final JPQLTemplates templates;

    public HibernateUpdateClause(Session session, EntityPath<?> entity) {
        this(new DefaultSessionHolder(session), entity, (JPQLTemplates)HQLTemplates.DEFAULT);
    }

    public HibernateUpdateClause(StatelessSession session, EntityPath<?> entity) {
        this(new StatelessSessionHolder(session), entity, (JPQLTemplates)HQLTemplates.DEFAULT);
    }

    public HibernateUpdateClause(Session session, EntityPath<?> entity, JPQLTemplates templates) {
        this(new DefaultSessionHolder(session), entity, templates);
    }

    public HibernateUpdateClause(SessionHolder session, EntityPath<?> entity, JPQLTemplates templates) {
        this.session = session;
        this.templates = templates;
        this.metadata.addJoin(JoinType.DEFAULT, entity);
    }

    public long execute() {
        JPQLSerializer serializer = new JPQLSerializer(this.templates, null);
        serializer.serializeForUpdate(this.metadata);
        Map constants = serializer.getConstantToLabel();
        Query query = this.session.createQuery(serializer.toString());
        HibernateUtil.setConstants(query, constants, this.metadata.getParams());
        return query.executeUpdate();
    }

    public <T> HibernateUpdateClause set(Path<T> path, T value) {
        if (value != null) {
            this.metadata.addProjection(new Expression[]{ExpressionUtils.eqConst(path, value)});
        } else {
            this.setNull(path);
        }
        return this;
    }

    public <T> HibernateUpdateClause set(Path<T> path, Expression<? extends T> expression) {
        if (expression != null) {
            this.metadata.addProjection(new Expression[]{ExpressionUtils.eq(path, expression)});
        } else {
            this.setNull(path);
        }
        return this;
    }

    public <T> HibernateUpdateClause setNull(Path<T> path) {
        this.metadata.addProjection(new Expression[]{ExpressionUtils.eq(path, (Expression)new NullExpression(path.getType()))});
        return this;
    }

    public HibernateUpdateClause set(List<? extends Path<?>> paths, List<?> values) {
        for (int i = 0; i < paths.size(); ++i) {
            if (values.get(i) != null) {
                this.metadata.addProjection(new Expression[]{ExpressionUtils.eqConst((Expression)((Expression)paths.get(i)), values.get(i))});
                continue;
            }
            this.metadata.addProjection(new Expression[]{ExpressionUtils.eq((Expression)((Expression)paths.get(i)), (Expression)new NullExpression(paths.get(i).getType()))});
        }
        return this;
    }

    public HibernateUpdateClause where(Predicate ... o) {
        this.metadata.addWhere(o);
        return this;
    }

    public String toString() {
        JPQLSerializer serializer = new JPQLSerializer(this.templates, null);
        serializer.serializeForUpdate(this.metadata);
        return serializer.toString();
    }
}

