/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.jpa;

import com.mysema.query.QueryMetadata;
import com.mysema.query.sql.SQLSerializer;
import com.mysema.query.sql.SQLTemplates;
import com.mysema.query.types.Constant;
import com.mysema.query.types.Expression;
import com.mysema.query.types.ExpressionUtils;
import com.mysema.query.types.FactoryExpression;
import com.mysema.query.types.Operation;
import com.mysema.query.types.Ops;
import com.mysema.query.types.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.persistence.Entity;

public final class NativeSQLSerializer
extends SQLSerializer {
    private final List<Path<?>> entityPaths = new ArrayList();

    public NativeSQLSerializer(SQLTemplates templates) {
        super(templates);
    }

    public void serialize(QueryMetadata metadata, boolean forCountRow) {
        int size = metadata.getProjection().size();
        Expression[] args = metadata.getProjection().toArray(new Expression[size]);
        boolean modified = false;
        HashSet<String> used = new HashSet<String>();
        for (int i = 0; i < args.length; ++i) {
            if (args[i] instanceof Path) {
                Path path = (Path)args[i];
                if (used.add(path.getMetadata().getExpression().toString())) continue;
                args[i] = ExpressionUtils.as((Expression)args[i], (String)("col__" + (i + 1)));
                modified = true;
                continue;
            }
            if (this.isAlias(args[i]) || args[i] instanceof FactoryExpression || args[i].toString().contains("*")) continue;
            args[i] = ExpressionUtils.as((Expression)args[i], (String)("col__" + (i + 1)));
            modified = true;
        }
        if (modified) {
            metadata = metadata.clone();
            metadata.clearProjection();
            metadata.addProjection(args);
        }
        super.serialize(metadata, forCountRow);
    }

    private boolean isAlias(Expression<?> expr) {
        return expr instanceof Operation && ((Operation)expr).getOperator() == Ops.ALIAS;
    }

    public Void visit(Constant<?> expr, Void context) {
        if (expr.getConstant() instanceof Collection) {
            this.append(new String[]{"("});
            boolean first = true;
            for (Object element : (Collection)expr.getConstant()) {
                if (!first) {
                    this.append(new String[]{", "});
                }
                this.visitConstant(element);
                first = false;
            }
            this.append(new String[]{")"});
        } else {
            this.visitConstant(expr.getConstant());
        }
        return null;
    }

    private void visitConstant(Object constant) {
        if (!this.getConstantToLabel().containsKey(constant)) {
            String constLabel = String.valueOf(this.getConstantToLabel().size() + 1);
            this.getConstantToLabel().put(constant, constLabel);
            this.append(new String[]{"?" + constLabel});
        } else {
            this.append(new String[]{"?" + (String)this.getConstantToLabel().get(constant)});
        }
    }

    public Void visit(Path<?> path, Void context) {
        if (path.getMetadata().getParent() == null && path.getType().isAnnotationPresent(Entity.class)) {
            super.visit(path, context);
            if (this.stage == SQLSerializer.Stage.SELECT) {
                this.append(new String[]{".*"});
            }
            this.entityPaths.add(path);
        } else {
            super.visit(path, context);
        }
        return null;
    }

    public List<Path<?>> getEntityPaths() {
        return this.entityPaths;
    }
}

