/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.jpa.impl;

import com.mysema.query.DefaultQueryMetadata;
import com.mysema.query.JoinType;
import com.mysema.query.QueryMetadata;
import com.mysema.query.dml.DeleteClause;
import com.mysema.query.jpa.JPQLSerializer;
import com.mysema.query.jpa.JPQLTemplates;
import com.mysema.query.jpa.impl.JPAProvider;
import com.mysema.query.jpa.impl.JPAUtil;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Predicate;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Query;

public class JPADeleteClause
implements DeleteClause<JPADeleteClause> {
    private final QueryMetadata metadata = new DefaultQueryMetadata();
    private final EntityManager entityManager;
    private final JPQLTemplates templates;

    public JPADeleteClause(EntityManager em, EntityPath<?> entity) {
        this(em, entity, JPAProvider.getTemplates(em));
    }

    public JPADeleteClause(EntityManager entityManager, EntityPath<?> entity, JPQLTemplates templates) {
        this.entityManager = entityManager;
        this.templates = templates;
        this.metadata.addJoin(JoinType.DEFAULT, entity);
    }

    public long execute() {
        JPQLSerializer serializer = new JPQLSerializer(this.templates, this.entityManager);
        serializer.serializeForDelete(this.metadata);
        Map constants = serializer.getConstantToLabel();
        Query query = this.entityManager.createQuery(serializer.toString());
        JPAUtil.setConstants(query, constants, this.metadata.getParams());
        return query.executeUpdate();
    }

    public JPADeleteClause where(Predicate ... o) {
        this.metadata.addWhere(o);
        return this;
    }

    public String toString() {
        JPQLSerializer serializer = new JPQLSerializer(this.templates, this.entityManager);
        serializer.serializeForDelete(this.metadata);
        return serializer.toString();
    }
}

