/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.jpa;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mysema.query.JoinExpression;
import com.mysema.query.JoinType;
import com.mysema.query.QueryMetadata;
import com.mysema.query.jpa.JPAQueryMixin;
import com.mysema.query.jpa.JPQLTemplates;
import com.mysema.query.support.SerializerBase;
import com.mysema.query.types.Constant;
import com.mysema.query.types.ConstantImpl;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.ExpressionUtils;
import com.mysema.query.types.FactoryExpression;
import com.mysema.query.types.Operation;
import com.mysema.query.types.Operator;
import com.mysema.query.types.Ops;
import com.mysema.query.types.OrderSpecifier;
import com.mysema.query.types.ParamExpression;
import com.mysema.query.types.Path;
import com.mysema.query.types.PathImpl;
import com.mysema.query.types.PathType;
import com.mysema.query.types.Predicate;
import com.mysema.query.types.SubQueryExpression;
import com.mysema.query.types.Templates;
import com.mysema.util.MathUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.PersistenceUnitUtil;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.Metamodel;
import javax.persistence.metamodel.SingularAttribute;

public class JPQLSerializer
extends SerializerBase<JPQLSerializer> {
    private static final Set<Operator<?>> NUMERIC = ImmutableSet.of((Object)Ops.ADD, (Object)Ops.SUB, (Object)Ops.MULT, (Object)Ops.DIV, (Object)Ops.LT, (Object)Ops.LOE, (Object[])new Operator[]{Ops.GT, Ops.GOE, Ops.BETWEEN});
    private static final String COMMA = ", ";
    private static final String DELETE = "delete from ";
    private static final String FROM = "from ";
    private static final String GROUP_BY = "\ngroup by ";
    private static final String HAVING = "\nhaving ";
    private static final String ORDER_BY = "\norder by ";
    private static final String SELECT = "select ";
    private static final String SELECT_COUNT = "select count(";
    private static final String SELECT_COUNT_DISTINCT = "select count(distinct ";
    private static final String SELECT_DISTINCT = "select distinct ";
    private static final String SET = "\nset ";
    private static final String UPDATE = "update ";
    private static final String WHERE = "\nwhere ";
    private static final String WITH = " with ";
    private static final String ON = " on ";
    private static final Map<JoinType, String> joinTypes = new HashMap<JoinType, String>();
    private final JPQLTemplates templates;
    private final EntityManager entityManager;
    private boolean inProjection = false;
    private boolean wrapElements = false;

    public JPQLSerializer(JPQLTemplates templates) {
        this(templates, null);
    }

    public JPQLSerializer(JPQLTemplates templates, EntityManager em) {
        super((Templates)templates);
        this.templates = templates;
        this.entityManager = em;
    }

    private void handleJoinTarget(JoinExpression je) {
        EntityPath pe;
        if (je.getTarget() instanceof EntityPath && (pe = (EntityPath)je.getTarget()).getMetadata().isRoot()) {
            Entity entityAnnotation = pe.getAnnotatedElement().getAnnotation(Entity.class);
            if (entityAnnotation != null && entityAnnotation.name().length() > 0) {
                this.append(entityAnnotation.name());
            } else if (pe.getType().getPackage() != null) {
                String pn = pe.getType().getPackage().getName();
                String typeName = pe.getType().getName().substring(pn.length() + 1);
                this.append(typeName);
            } else {
                this.append(pe.getType().getName());
            }
            this.append(" ");
        }
        this.handle(je.getTarget());
    }

    public void serialize(QueryMetadata metadata, boolean forCountRow, @Nullable String projection) {
        List select = metadata.getProjection();
        List joins = metadata.getJoins();
        Predicate where = metadata.getWhere();
        List groupBy = metadata.getGroupBy();
        Predicate having = metadata.getHaving();
        List orderBy = metadata.getOrderBy();
        boolean inProjectionOrig = this.inProjection;
        this.inProjection = true;
        if (projection != null) {
            ((JPQLSerializer)((JPQLSerializer)this.append(SELECT)).append(projection)).append("\n");
        } else if (forCountRow) {
            if (!metadata.isDistinct()) {
                this.append(SELECT_COUNT);
            } else {
                this.append(SELECT_COUNT_DISTINCT);
            }
            if (!select.isEmpty()) {
                if (select.get(0) instanceof FactoryExpression) {
                    this.handle(((JoinExpression)joins.get(0)).getTarget());
                } else {
                    this.handle(COMMA, select);
                }
            } else {
                this.handle(((JoinExpression)joins.get(0)).getTarget());
            }
            this.append(")\n");
        } else {
            if (!metadata.isDistinct()) {
                this.append(SELECT);
            } else {
                this.append(SELECT_DISTINCT);
            }
            if (!select.isEmpty()) {
                this.handle(COMMA, select);
            } else {
                this.handle(((JoinExpression)metadata.getJoins().get(0)).getTarget());
            }
            this.append("\n");
        }
        this.inProjection = inProjectionOrig;
        this.append(FROM);
        this.serializeSources(forCountRow, joins);
        if (where != null) {
            ((JPQLSerializer)this.append(WHERE)).handle((Expression)where);
        }
        if (!groupBy.isEmpty()) {
            ((JPQLSerializer)this.append(GROUP_BY)).handle(COMMA, groupBy);
        }
        if (having != null) {
            ((JPQLSerializer)this.append(HAVING)).handle((Expression)having);
        }
        if (!orderBy.isEmpty() && !forCountRow) {
            this.append(ORDER_BY);
            boolean first = true;
            for (OrderSpecifier os : orderBy) {
                if (!first) {
                    this.append(COMMA);
                }
                this.handle(os.getTarget());
                this.append(" " + os.getOrder().toString().toLowerCase(Locale.ENGLISH));
                first = false;
            }
        }
    }

    public void serializeForDelete(QueryMetadata md) {
        this.append(DELETE);
        this.handleJoinTarget((JoinExpression)md.getJoins().get(0));
        if (md.getWhere() != null) {
            ((JPQLSerializer)this.append(WHERE)).handle((Expression)md.getWhere());
        }
    }

    public void serializeForUpdate(QueryMetadata md) {
        this.append(UPDATE);
        this.handleJoinTarget((JoinExpression)md.getJoins().get(0));
        this.append(SET);
        this.handle(COMMA, md.getProjection());
        if (md.getWhere() != null) {
            ((JPQLSerializer)this.append(WHERE)).handle((Expression)md.getWhere());
        }
    }

    private void serializeSources(boolean forCountRow, List<JoinExpression> joins) {
        for (int i = 0; i < joins.size(); ++i) {
            JoinExpression je = joins.get(i);
            if (i > 0) {
                this.append(joinTypes.get(je.getType()));
            }
            if (je.hasFlag(JPAQueryMixin.FETCH) && !forCountRow) {
                this.handle(JPAQueryMixin.FETCH);
            }
            this.handleJoinTarget(je);
            if (je.hasFlag(JPAQueryMixin.FETCH_ALL_PROPERTIES) && !forCountRow) {
                this.handle(JPAQueryMixin.FETCH_ALL_PROPERTIES);
            }
            if (je.getCondition() == null) continue;
            this.append(this.templates.isWithForOn() ? WITH : ON);
            this.handle((Expression)je.getCondition());
        }
    }

    public void visitConstant(Object constant) {
        boolean wrap = this.templates.wrapConstant(constant);
        if (wrap) {
            this.append("(");
        }
        this.append("?");
        if (!this.getConstantToLabel().containsKey(constant)) {
            String constLabel = String.valueOf(this.getConstantToLabel().size() + 1);
            this.getConstantToLabel().put(constant, constLabel);
            this.append(constLabel);
        } else {
            this.append((String)this.getConstantToLabel().get(constant));
        }
        if (wrap) {
            this.append(")");
        }
    }

    public Void visit(ParamExpression<?> param, Void context) {
        this.append("?");
        if (!this.getConstantToLabel().containsKey(param)) {
            String paramLabel = String.valueOf(this.getConstantToLabel().size() + 1);
            this.getConstantToLabel().put(param, paramLabel);
            this.append(paramLabel);
        } else {
            this.append((String)this.getConstantToLabel().get(param));
        }
        return null;
    }

    public Void visit(SubQueryExpression<?> query, Void context) {
        this.append("(");
        this.serialize(query.getMetadata(), false, null);
        this.append(")");
        return null;
    }

    public Void visit(Path<?> expr, Void context) {
        boolean wrap;
        boolean bl = wrap = this.wrapElements && (Collection.class.isAssignableFrom(expr.getType()) || Map.class.isAssignableFrom(expr.getType())) && expr.getMetadata().getPathType().equals((Object)PathType.PROPERTY);
        if (wrap) {
            this.append("elements(");
        }
        super.visit(expr, context);
        if (wrap) {
            this.append(")");
        }
        return null;
    }

    public Void visit(FactoryExpression<?> expr, Void context) {
        if (!this.inProjection) {
            this.append("(");
            super.visit(expr, context);
            this.append(")");
        } else {
            super.visit(expr, context);
        }
        return null;
    }

    protected void visitOperation(Class<?> type, Operator<?> operator, List<? extends Expression<?>> args) {
        boolean old = this.wrapElements;
        this.wrapElements = this.templates.wrapElements(operator);
        if (operator == Ops.EQ && args.get(1) instanceof Operation && ((Operation)args.get(1)).getOperator() == Ops.QuantOps.ANY) {
            args = ImmutableList.of(args.get(0), (Object)((Operation)args.get(1)).getArg(0));
            this.visitOperation(type, (Operator<?>)Ops.IN, (List<? extends Expression<?>>)args);
        } else if (operator == Ops.IN) {
            if (args.get(1) instanceof Path) {
                this.visitAnyInPath(type, (List<? extends Expression<?>>)args);
            } else if (args.get(0) instanceof Path && args.get(1) instanceof Constant) {
                this.visitPathInCollection(type, operator, (List<? extends Expression<?>>)args);
            } else {
                super.visitOperation(type, operator, args);
            }
        } else if (operator == Ops.INSTANCE_OF) {
            this.visitInstanceOf(type, operator, (List<? extends Expression<?>>)args);
        } else if (operator == Ops.NUMCAST) {
            this.visitNumCast((List<? extends Expression<?>>)args);
        } else if (operator == Ops.EXISTS && args.get(0) instanceof SubQueryExpression) {
            SubQueryExpression subQuery = (SubQueryExpression)args.get(0);
            this.append("exists (");
            this.serialize(subQuery.getMetadata(), false, this.templates.getExistsProjection());
            this.append(")");
        } else if (operator == Ops.MATCHES || operator == Ops.MATCHES_IC) {
            super.visitOperation(type, Ops.LIKE, (List)ImmutableList.of(args.get(0), (Object)ExpressionUtils.regexToLike((Expression)((Expression)args.get(1)))));
        } else if (NUMERIC.contains(operator)) {
            super.visitOperation(type, operator, this.normalizeNumericArgs((List<? extends Expression<?>>)args));
        } else {
            super.visitOperation(type, operator, (List)args);
        }
        this.wrapElements = old;
    }

    private void visitNumCast(List<? extends Expression<?>> args) {
        Class targetType = (Class)((Constant)args.get(1)).getConstant();
        String typeName = targetType.getSimpleName().toLowerCase(Locale.ENGLISH);
        this.visitOperation(targetType, JPQLTemplates.CAST, (List<? extends Expression<?>>)ImmutableList.of(args.get(0), (Object)ConstantImpl.create((String)typeName)));
    }

    private void visitInstanceOf(Class<?> type, Operator<?> operator, List<? extends Expression<?>> args) {
        if (this.templates.isTypeAsString()) {
            ArrayList newArgs = new ArrayList(args);
            Class cl = (Class)((Constant)newArgs.get(1)).getConstant();
            if (cl.getAnnotation(DiscriminatorValue.class) != null) {
                newArgs.set(1, (Expression<?>)ConstantImpl.create((String)cl.getAnnotation(DiscriminatorValue.class).value()));
            } else {
                newArgs.set(1, (Expression<?>)ConstantImpl.create((String)cl.getSimpleName()));
            }
            super.visitOperation(type, operator, newArgs);
        } else {
            super.visitOperation(type, operator, args);
        }
    }

    private void visitPathInCollection(Class<?> type, Operator<?> operator, List<? extends Expression<?>> args) {
        if (this.entityManager != null && !this.templates.isPathInEntitiesSupported() && args.get(0).getType().isAnnotationPresent(Entity.class)) {
            Path lhs = (Path)args.get(0);
            Constant rhs = (Constant)args.get(1);
            Metamodel metamodel = this.entityManager.getMetamodel();
            PersistenceUnitUtil util = this.entityManager.getEntityManagerFactory().getPersistenceUnitUtil();
            EntityType entityType = metamodel.entity(args.get(0).getType());
            if (entityType.hasSingleIdAttribute()) {
                SingularAttribute<?, ?> id = this.getIdProperty(entityType);
                lhs = new PathImpl(id.getJavaType(), lhs, id.getName());
                HashSet<Object> ids = new HashSet<Object>();
                for (Object entity : (Collection)rhs.getConstant()) {
                    ids.add(util.getIdentifier(entity));
                }
                rhs = new ConstantImpl(ids);
                args = ImmutableList.of((Object)lhs, (Object)rhs);
            }
        }
        super.visitOperation(type, operator, args);
    }

    private SingularAttribute<?, ?> getIdProperty(EntityType entity) {
        Set singularAttributes = entity.getSingularAttributes();
        for (SingularAttribute singularAttribute : singularAttributes) {
            if (!singularAttribute.isId()) continue;
            return singularAttribute;
        }
        return null;
    }

    private void visitAnyInPath(Class<?> type, List<? extends Expression<?>> args) {
        if (!this.templates.isEnumInPathSupported() && args.get(0) instanceof Constant && Enum.class.isAssignableFrom(args.get(0).getType())) {
            Enumerated enumerated = ((Path)args.get(1)).getAnnotatedElement().getAnnotation(Enumerated.class);
            Enum constant = (Enum)((Constant)args.get(0)).getConstant();
            args = enumerated == null || enumerated.value() == EnumType.ORDINAL ? ImmutableList.of((Object)ConstantImpl.create((int)constant.ordinal()), args.get(1)) : ImmutableList.of((Object)new ConstantImpl((Object)constant.name()), args.get(1));
        }
        super.visitOperation(type, JPQLTemplates.MEMBER_OF, args);
    }

    private List<? extends Expression<?>> normalizeNumericArgs(List<? extends Expression<?>> args) {
        boolean hasConstants = false;
        Class numType = null;
        for (Expression<?> arg : args) {
            if (!Number.class.isAssignableFrom(arg.getType())) continue;
            if (arg instanceof Constant) {
                hasConstants = true;
                continue;
            }
            numType = arg.getType();
        }
        if (hasConstants && numType != null) {
            ArrayList<Object> newArgs = new ArrayList<Object>(args.size());
            for (Expression<?> arg : args) {
                if (arg instanceof Constant && Number.class.isAssignableFrom(arg.getType()) && !arg.getType().equals(numType)) {
                    Number number = (Number)((Constant)arg).getConstant();
                    newArgs.add(new ConstantImpl((Object)MathUtils.cast((Number)number, (Class)numType)));
                    continue;
                }
                newArgs.add(arg);
            }
            return newArgs;
        }
        return args;
    }

    static {
        joinTypes.put(JoinType.DEFAULT, COMMA);
        joinTypes.put(JoinType.FULLJOIN, "\n  full join ");
        joinTypes.put(JoinType.INNERJOIN, "\n  inner join ");
        joinTypes.put(JoinType.JOIN, "\n  inner join ");
        joinTypes.put(JoinType.LEFTJOIN, "\n  left join ");
        joinTypes.put(JoinType.RIGHTJOIN, "\n  right join ");
    }
}

