/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.jpa.sql;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mysema.commons.lang.CloseableIterator;
import com.mysema.query.DefaultQueryMetadata;
import com.mysema.query.NonUniqueResultException;
import com.mysema.query.Query;
import com.mysema.query.QueryMetadata;
import com.mysema.query.QueryModifiers;
import com.mysema.query.SearchResults;
import com.mysema.query.Tuple;
import com.mysema.query.jpa.AbstractSQLQuery;
import com.mysema.query.jpa.NativeSQLSerializer;
import com.mysema.query.jpa.QueryHandler;
import com.mysema.query.jpa.impl.JPAProvider;
import com.mysema.query.jpa.impl.JPAUtil;
import com.mysema.query.sql.SQLTemplates;
import com.mysema.query.sql.Union;
import com.mysema.query.sql.UnionImpl;
import com.mysema.query.sql.UnionUtils;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.FactoryExpression;
import com.mysema.query.types.FactoryExpressionUtils;
import com.mysema.query.types.Path;
import com.mysema.query.types.QTuple;
import com.mysema.query.types.SubQueryExpression;
import com.mysema.query.types.query.ListSubQuery;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.persistence.EntityManager;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.NoResultException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJPASQLQuery<Q extends AbstractJPASQLQuery<Q>>
extends AbstractSQLQuery<Q> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractJPASQLQuery.class);
    @Nullable
    private Map<Object, String> constants;
    private final EntityManager entityManager;
    protected final SQLTemplates templates;
    protected final Multimap<String, Object> hints = HashMultimap.create();
    protected final QueryHandler queryHandler;
    @Nullable
    protected Expression<?> union;
    private boolean unionAll;
    @Nullable
    protected LockModeType lockMode;
    @Nullable
    protected FlushModeType flushMode;
    @Nullable
    protected FactoryExpression<?> projection;

    public AbstractJPASQLQuery(EntityManager em, SQLTemplates sqlTemplates) {
        this(em, sqlTemplates, (QueryMetadata)new DefaultQueryMetadata());
    }

    public AbstractJPASQLQuery(EntityManager em, SQLTemplates sqlTemplates, QueryMetadata metadata) {
        super(metadata);
        this.entityManager = em;
        this.templates = sqlTemplates;
        this.queryHandler = JPAProvider.getTemplates(em).getQueryHandler();
    }

    private String buildQueryString(boolean forCountRow) {
        NativeSQLSerializer serializer = new NativeSQLSerializer(this.templates);
        if (this.union != null) {
            serializer.serializeUnion(this.union, this.queryMixin.getMetadata(), this.unionAll);
        } else {
            if (this.queryMixin.getMetadata().getJoins().isEmpty()) {
                throw new IllegalArgumentException("No joins given");
            }
            serializer.serialize(this.queryMixin.getMetadata(), forCountRow);
        }
        this.constants = serializer.getConstantToLabel();
        return serializer.toString();
    }

    public javax.persistence.Query createQuery(Expression<?> ... args) {
        this.queryMixin.getMetadata().setValidate(false);
        this.queryMixin.addProjection(args);
        return this.createQuery(this.toQueryString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private javax.persistence.Query createQuery(String queryString) {
        FactoryExpression wrapped;
        javax.persistence.Query query;
        this.logQuery(queryString);
        List projection = this.queryMixin.getMetadata().getProjection();
        if (projection.get(0) instanceof EntityPath) {
            if (projection.size() != 1) throw new IllegalArgumentException("Only single element entity projections are supported");
            query = this.entityManager.createNativeQuery(queryString, ((Expression)projection.get(0)).getType());
        } else {
            query = this.entityManager.createNativeQuery(queryString);
        }
        if (this.lockMode != null) {
            query.setLockMode(this.lockMode);
        }
        if (this.flushMode != null) {
            query.setFlushMode(this.flushMode);
        }
        for (Map.Entry entry : this.hints.entries()) {
            query.setHint((String)entry.getKey(), entry.getValue());
        }
        JPAUtil.setConstants(query, this.constants, this.queryMixin.getMetadata().getParams());
        FactoryExpression factoryExpression = wrapped = projection.size() > 1 ? FactoryExpressionUtils.wrap((List)projection) : null;
        if ((projection.size() != 1 || !(projection.get(0) instanceof FactoryExpression)) && wrapped == null) return query;
        this.projection = (FactoryExpression)projection.get(0);
        if (wrapped == null) return query;
        this.projection = wrapped;
        this.getMetadata().clearProjection();
        this.getMetadata().addProjection((Expression)wrapped);
        return query;
    }

    public List<Tuple> list(Expression<?> ... args) {
        return this.list((Expression<RT>)((Expression)new QTuple(args)));
    }

    private List<?> getResultList(javax.persistence.Query query) {
        if (this.projection != null) {
            List results = query.getResultList();
            ArrayList<Object> rv = new ArrayList<Object>(results.size());
            for (Object o : results) {
                if (o != null) {
                    if (!o.getClass().isArray()) {
                        o = new Object[]{o};
                    }
                    rv.add(this.projection.newInstance((Object[])o));
                    continue;
                }
                rv.add(null);
            }
            return rv;
        }
        return query.getResultList();
    }

    @Nullable
    private Object getSingleResult(javax.persistence.Query query) {
        if (this.projection != null) {
            Object[] result = query.getSingleResult();
            if (result != null) {
                if (!result.getClass().isArray()) {
                    result = new Object[]{result};
                }
                return this.projection.newInstance(result);
            }
            return null;
        }
        return query.getSingleResult();
    }

    public <RT> List<RT> list(Expression<RT> projection) {
        javax.persistence.Query query = this.createQuery(projection);
        return this.getResultList(query);
    }

    public CloseableIterator<Tuple> iterate(Expression<?> ... args) {
        return this.iterate((Expression<RT>)((Expression)new QTuple(args)));
    }

    public <RT> CloseableIterator<RT> iterate(Expression<RT> expr) {
        javax.persistence.Query query = this.createQuery(expr);
        return this.queryHandler.iterate(query, null);
    }

    public SearchResults<Tuple> listResults(Expression<?> ... args) {
        return this.listResults((Expression<RT>)((Expression)new QTuple(args)));
    }

    public <RT> SearchResults<RT> listResults(Expression<RT> projection) {
        this.queryMixin.addProjection(projection);
        javax.persistence.Query query = this.createQuery(this.toCountRowsString());
        long total = ((Number)query.getSingleResult()).longValue();
        if (total > 0L) {
            QueryModifiers modifiers = this.queryMixin.getMetadata().getModifiers();
            String queryString = this.toQueryString();
            query = this.createQuery(queryString);
            List<?> list = this.getResultList(query);
            this.reset();
            return new SearchResults(list, modifiers, total);
        }
        this.reset();
        return SearchResults.emptyResults();
    }

    protected void logQuery(String queryString) {
        if (logger.isDebugEnabled()) {
            logger.debug(queryString.replace('\n', ' '));
        }
    }

    protected void reset() {
        this.queryMixin.getMetadata().reset();
        this.constants = null;
    }

    protected String toCountRowsString() {
        return this.buildQueryString(true);
    }

    protected String toQueryString() {
        return this.buildQueryString(false);
    }

    public <RT> Union<RT> union(ListSubQuery<RT> ... sq) {
        return this.innerUnion((SubQueryExpression<?>[])sq);
    }

    public <RT> Union<RT> union(SubQueryExpression<RT> ... sq) {
        return this.innerUnion(sq);
    }

    public <RT> Union<RT> unionAll(ListSubQuery<RT> ... sq) {
        this.unionAll = true;
        return this.innerUnion((SubQueryExpression<?>[])sq);
    }

    public <RT> Union<RT> unionAll(SubQueryExpression<RT> ... sq) {
        this.unionAll = true;
        return this.innerUnion(sq);
    }

    public <RT> Q union(Path<?> alias, ListSubQuery<RT> ... sq) {
        return (Q)((Object)((AbstractJPASQLQuery)((Object)this.from((Expression<?>)UnionUtils.union(sq, alias, (boolean)false)))));
    }

    public <RT> Q union(Path<?> alias, SubQueryExpression<RT> ... sq) {
        return (Q)((Object)((AbstractJPASQLQuery)((Object)this.from((Expression<?>)UnionUtils.union(sq, alias, (boolean)false)))));
    }

    public <RT> Q unionAll(Path<?> alias, ListSubQuery<RT> ... sq) {
        return (Q)((Object)((AbstractJPASQLQuery)((Object)this.from((Expression<?>)UnionUtils.union(sq, alias, (boolean)true)))));
    }

    public <RT> Q unionAll(Path<?> alias, SubQueryExpression<RT> ... sq) {
        return (Q)((Object)((AbstractJPASQLQuery)((Object)this.from((Expression<?>)UnionUtils.union(sq, alias, (boolean)true)))));
    }

    private <RT> Union<RT> innerUnion(SubQueryExpression<?> ... sq) {
        this.queryMixin.getMetadata().setValidate(false);
        if (!this.queryMixin.getMetadata().getJoins().isEmpty()) {
            throw new IllegalArgumentException("Don't mix union and from");
        }
        this.union = UnionUtils.union(sq, (boolean)this.unionAll);
        return new UnionImpl((Query)this, sq[0].getMetadata().getProjection());
    }

    public Tuple uniqueResult(Expression<?> ... args) {
        return (Tuple)this.uniqueResult((Expression<RT>)((Expression)new QTuple(args)));
    }

    public <RT> RT uniqueResult(Expression<RT> expr) {
        javax.persistence.Query query = this.createQuery(expr);
        return (RT)this.uniqueResult(query);
    }

    @Nullable
    private Object uniqueResult(javax.persistence.Query query) {
        try {
            Object object = this.getSingleResult(query);
            return object;
        }
        catch (NoResultException e) {
            logger.trace(e.getMessage(), (Throwable)e);
            Object var3_5 = null;
            return var3_5;
        }
        catch (javax.persistence.NonUniqueResultException e) {
            throw new NonUniqueResultException();
        }
        finally {
            this.reset();
        }
    }

    public Q setLockMode(LockModeType lockMode) {
        this.lockMode = lockMode;
        return (Q)((Object)this);
    }

    public Q setFlushMode(FlushModeType flushMode) {
        this.flushMode = flushMode;
        return (Q)((Object)this);
    }

    public Q setHint(String name, Object value) {
        this.hints.put((Object)name, value);
        return (Q)((Object)this);
    }
}

