/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.jpa;

import com.mysema.query.JoinExpression;
import com.mysema.query.QueryMetadata;
import com.mysema.query.jpa.JPAQueryMixin;
import com.mysema.query.jpa.JPQLQuery;
import com.mysema.query.jpa.JPQLSerializer;
import com.mysema.query.jpa.JPQLTemplates;
import com.mysema.query.support.ProjectableQuery;
import com.mysema.query.types.CollectionExpression;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.MapExpression;
import com.mysema.query.types.Path;
import com.mysema.query.types.Predicate;
import com.mysema.query.types.template.NumberTemplate;
import java.util.Map;
import javax.annotation.Nullable;
import javax.persistence.EntityManager;

public abstract class JPAQueryBase<Q extends JPAQueryBase<Q>>
extends ProjectableQuery<Q>
implements JPQLQuery {
    private Map<Object, String> constants;
    protected final JPAQueryMixin<Q> queryMixin;
    private final JPQLTemplates templates;
    @Nullable
    protected final EntityManager entityManager;

    public JPAQueryBase(QueryMetadata md, JPQLTemplates templates, @Nullable EntityManager entityManager) {
        super(new JPAQueryMixin(md));
        ((ProjectableQuery)this).queryMixin.setSelf((Object)this);
        this.queryMixin = (JPAQueryMixin)((ProjectableQuery)this).queryMixin;
        this.templates = templates;
        this.entityManager = entityManager;
    }

    protected JPQLTemplates getTemplates() {
        return this.templates;
    }

    protected String buildQueryString(boolean forCountRow) {
        if (this.queryMixin.getMetadata().getJoins().isEmpty()) {
            throw new IllegalArgumentException("No joins given");
        }
        JPQLSerializer serializer = new JPQLSerializer(this.templates, this.entityManager);
        serializer.serialize(this.queryMixin.getMetadata(), forCountRow, null);
        this.constants = serializer.getConstantToLabel();
        return serializer.toString();
    }

    protected void reset() {
        this.queryMixin.getMetadata().reset();
    }

    public boolean exists() {
        if (this.templates.isSelect1Supported()) {
            return ((JPAQueryBase)this.limit(1L)).singleResult((Expression)NumberTemplate.ONE) != null;
        }
        EntityPath entityPath = (EntityPath)((JoinExpression)this.queryMixin.getMetadata().getJoins().get(0)).getTarget();
        return !((JPAQueryBase)this.limit(1L)).list((Expression)entityPath).isEmpty();
    }

    public Q fetch() {
        return (Q)((JPAQueryBase)this.queryMixin.fetch());
    }

    public Q fetchAll() {
        return (Q)((JPAQueryBase)this.queryMixin.fetchAll());
    }

    public Q from(EntityPath<?> arg) {
        return (Q)((JPAQueryBase)this.queryMixin.from((Expression)arg));
    }

    @Override
    public Q from(EntityPath<?> ... args) {
        return (Q)((JPAQueryBase)this.queryMixin.from((Expression[])args));
    }

    @Override
    public <P> Q fullJoin(CollectionExpression<?, P> target) {
        return (Q)((JPAQueryBase)this.queryMixin.fullJoin((Expression)target));
    }

    @Override
    public <P> Q fullJoin(CollectionExpression<?, P> target, Path<P> alias) {
        return (Q)((JPAQueryBase)this.queryMixin.fullJoin(target, alias));
    }

    @Override
    public <P> Q fullJoin(EntityPath<P> target) {
        return (Q)((JPAQueryBase)this.queryMixin.fullJoin((Expression)target));
    }

    @Override
    public <P> Q fullJoin(EntityPath<P> target, Path<P> alias) {
        return (Q)((JPAQueryBase)this.queryMixin.fullJoin((Expression)target, (Path)alias));
    }

    @Override
    public <P> Q fullJoin(MapExpression<?, P> target) {
        return (Q)((JPAQueryBase)this.queryMixin.fullJoin((Expression)target));
    }

    @Override
    public <P> Q fullJoin(MapExpression<?, P> target, Path<P> alias) {
        return (Q)((JPAQueryBase)this.queryMixin.fullJoin(target, alias));
    }

    protected Map<Object, String> getConstants() {
        return this.constants;
    }

    @Override
    public <P> Q innerJoin(CollectionExpression<?, P> target) {
        return (Q)((JPAQueryBase)this.queryMixin.innerJoin((Expression)target));
    }

    @Override
    public <P> Q innerJoin(CollectionExpression<?, P> target, Path<P> alias) {
        return (Q)((JPAQueryBase)this.queryMixin.innerJoin(target, alias));
    }

    @Override
    public <P> Q innerJoin(EntityPath<P> target) {
        return (Q)((JPAQueryBase)this.queryMixin.innerJoin((Expression)target));
    }

    @Override
    public <P> Q innerJoin(EntityPath<P> target, Path<P> alias) {
        return (Q)((JPAQueryBase)this.queryMixin.innerJoin((Expression)target, (Path)alias));
    }

    @Override
    public <P> Q innerJoin(MapExpression<?, P> target) {
        return (Q)((JPAQueryBase)this.queryMixin.innerJoin((Expression)target));
    }

    @Override
    public <P> Q innerJoin(MapExpression<?, P> target, Path<P> alias) {
        return (Q)((JPAQueryBase)this.queryMixin.innerJoin(target, alias));
    }

    @Override
    public <P> Q join(CollectionExpression<?, P> target) {
        return (Q)((JPAQueryBase)this.queryMixin.join((Expression)target));
    }

    @Override
    public <P> Q join(CollectionExpression<?, P> target, Path<P> alias) {
        return (Q)((JPAQueryBase)this.queryMixin.join(target, alias));
    }

    @Override
    public <P> Q join(EntityPath<P> target) {
        return (Q)((JPAQueryBase)this.queryMixin.join((Expression)target));
    }

    @Override
    public <P> Q join(EntityPath<P> target, Path<P> alias) {
        return (Q)((JPAQueryBase)this.queryMixin.join((Expression)target, (Path)alias));
    }

    @Override
    public <P> Q join(MapExpression<?, P> target) {
        return (Q)((JPAQueryBase)this.queryMixin.join((Expression)target));
    }

    @Override
    public <P> Q join(MapExpression<?, P> target, Path<P> alias) {
        return (Q)((JPAQueryBase)this.queryMixin.join(target, alias));
    }

    @Override
    public <P> Q leftJoin(CollectionExpression<?, P> target) {
        return (Q)((JPAQueryBase)this.queryMixin.leftJoin((Expression)target));
    }

    @Override
    public <P> Q leftJoin(CollectionExpression<?, P> target, Path<P> alias) {
        return (Q)((JPAQueryBase)this.queryMixin.leftJoin(target, alias));
    }

    @Override
    public <P> Q leftJoin(EntityPath<P> target) {
        return (Q)((JPAQueryBase)this.queryMixin.leftJoin((Expression)target));
    }

    @Override
    public <P> Q leftJoin(EntityPath<P> target, Path<P> alias) {
        return (Q)((JPAQueryBase)this.queryMixin.leftJoin((Expression)target, (Path)alias));
    }

    @Override
    public <P> Q leftJoin(MapExpression<?, P> target) {
        return (Q)((JPAQueryBase)this.queryMixin.leftJoin((Expression)target));
    }

    @Override
    public <P> Q leftJoin(MapExpression<?, P> target, Path<P> alias) {
        return (Q)((JPAQueryBase)this.queryMixin.leftJoin(target, alias));
    }

    @Override
    public <P> Q rightJoin(CollectionExpression<?, P> target) {
        return (Q)((JPAQueryBase)this.queryMixin.rightJoin((Expression)target));
    }

    @Override
    public <P> Q rightJoin(CollectionExpression<?, P> target, Path<P> alias) {
        return (Q)((JPAQueryBase)this.queryMixin.rightJoin(target, alias));
    }

    @Override
    public <P> Q rightJoin(EntityPath<P> target) {
        return (Q)((JPAQueryBase)this.queryMixin.rightJoin((Expression)target));
    }

    @Override
    public <P> Q rightJoin(EntityPath<P> target, Path<P> alias) {
        return (Q)((JPAQueryBase)this.queryMixin.rightJoin((Expression)target, (Path)alias));
    }

    @Override
    public <P> Q rightJoin(MapExpression<?, P> target) {
        return (Q)((JPAQueryBase)this.queryMixin.rightJoin((Expression)target));
    }

    @Override
    public <P> Q rightJoin(MapExpression<?, P> target, Path<P> alias) {
        return (Q)((JPAQueryBase)this.queryMixin.rightJoin(target, alias));
    }

    public Q on(Predicate condition) {
        return (Q)((JPAQueryBase)this.queryMixin.on(condition));
    }

    @Override
    public Q on(Predicate ... conditions) {
        return (Q)((JPAQueryBase)this.queryMixin.on(conditions));
    }

    protected void setConstants(Map<Object, String> constants) {
        this.constants = constants;
    }

    protected String toCountRowsString() {
        return this.buildQueryString(true);
    }

    protected String toQueryString() {
        return this.buildQueryString(false);
    }

    public String toString() {
        return this.buildQueryString(false).trim();
    }

    public QueryMetadata getMetadata() {
        return this.queryMixin.getMetadata();
    }
}

