/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.jpa.hibernate.sql;

import com.mysema.commons.lang.CloseableIterator;
import com.mysema.commons.lang.IteratorAdapter;
import com.mysema.query.DefaultQueryMetadata;
import com.mysema.query.NonUniqueResultException;
import com.mysema.query.Query;
import com.mysema.query.QueryMetadata;
import com.mysema.query.QueryModifiers;
import com.mysema.query.SearchResults;
import com.mysema.query.Tuple;
import com.mysema.query.jpa.AbstractSQLQuery;
import com.mysema.query.jpa.FactoryExpressionTransformer;
import com.mysema.query.jpa.NativeSQLSerializer;
import com.mysema.query.jpa.hibernate.DefaultSessionHolder;
import com.mysema.query.jpa.hibernate.HibernateUtil;
import com.mysema.query.jpa.hibernate.SessionHolder;
import com.mysema.query.jpa.hibernate.StatelessSessionHolder;
import com.mysema.query.sql.Configuration;
import com.mysema.query.sql.Union;
import com.mysema.query.sql.UnionImpl;
import com.mysema.query.sql.UnionUtils;
import com.mysema.query.types.Expression;
import com.mysema.query.types.FactoryExpression;
import com.mysema.query.types.Path;
import com.mysema.query.types.QTuple;
import com.mysema.query.types.SubQueryExpression;
import com.mysema.query.types.query.ListSubQuery;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.StatelessSession;
import org.hibernate.transform.ResultTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHibernateSQLQuery<Q extends AbstractHibernateSQLQuery<Q>>
extends AbstractSQLQuery<Q> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractHibernateSQLQuery.class);
    protected Boolean cacheable;
    protected Boolean readOnly;
    protected String cacheRegion;
    @Nullable
    private Map<Object, String> constants;
    @Nullable
    private List<Path<?>> entityPaths;
    protected int fetchSize = 0;
    private final SessionHolder session;
    protected final Configuration configuration;
    protected int timeout = 0;
    @Nullable
    protected Expression<?> union;
    private boolean unionAll;

    public AbstractHibernateSQLQuery(Session session, Configuration conf) {
        this(new DefaultSessionHolder(session), conf, (QueryMetadata)new DefaultQueryMetadata());
    }

    public AbstractHibernateSQLQuery(StatelessSession session, Configuration conf) {
        this(new StatelessSessionHolder(session), conf, (QueryMetadata)new DefaultQueryMetadata());
    }

    public AbstractHibernateSQLQuery(SessionHolder session, Configuration conf, QueryMetadata metadata) {
        super(metadata);
        this.session = session;
        this.configuration = conf;
    }

    private String buildQueryString(boolean forCountRow) {
        NativeSQLSerializer serializer = new NativeSQLSerializer(this.configuration);
        if (this.union != null) {
            serializer.serializeUnion(this.union, this.queryMixin.getMetadata(), this.unionAll);
        } else {
            if (this.queryMixin.getMetadata().getJoins().isEmpty()) {
                throw new IllegalArgumentException("No joins given");
            }
            serializer.serialize(this.queryMixin.getMetadata(), forCountRow);
        }
        this.constants = serializer.getConstantToLabel();
        this.entityPaths = serializer.getEntityPaths();
        return serializer.toString();
    }

    public org.hibernate.Query createQuery(Expression<?> ... args) {
        this.queryMixin.getMetadata().setValidate(false);
        this.queryMixin.addProjection(args);
        return this.createQuery(this.toQueryString());
    }

    private org.hibernate.Query createQuery(String queryString) {
        this.logQuery(queryString);
        SQLQuery query = this.session.createSQLQuery(queryString);
        HibernateUtil.setConstants((org.hibernate.Query)query, this.constants, this.queryMixin.getMetadata().getParams());
        for (Path<?> path : this.entityPaths) {
            query.addEntity(path.toString(), path.getType());
        }
        List projection = this.queryMixin.getMetadata().getProjection();
        if (projection.size() == 1 && projection.get(0) instanceof FactoryExpression) {
            query.setResultTransformer((ResultTransformer)new FactoryExpressionTransformer((FactoryExpression)projection.get(0)));
        }
        if (this.fetchSize > 0) {
            query.setFetchSize(this.fetchSize);
        }
        if (this.timeout > 0) {
            query.setTimeout(this.timeout);
        }
        if (this.cacheable != null) {
            query.setCacheable(this.cacheable.booleanValue());
        }
        if (this.cacheRegion != null) {
            query.setCacheRegion(this.cacheRegion);
        }
        if (this.readOnly != null) {
            query.setReadOnly(this.readOnly.booleanValue());
        }
        return query;
    }

    public List<Tuple> list(Expression<?> ... projection) {
        return this.list((Expression<RT>)((Expression)new QTuple(projection)));
    }

    public <RT> List<RT> list(Expression<RT> projection) {
        org.hibernate.Query query = this.createQuery(projection);
        this.reset();
        return query.list();
    }

    public CloseableIterator<Tuple> iterate(Expression<?> ... args) {
        return this.iterate((Expression<RT>)((Expression)new QTuple(args)));
    }

    public <RT> CloseableIterator<RT> iterate(Expression<RT> projection) {
        return new IteratorAdapter(this.list(projection).iterator());
    }

    public SearchResults<Tuple> listResults(Expression<?> ... args) {
        return this.listResults((Expression<RT>)((Expression)new QTuple(args)));
    }

    public <RT> SearchResults<RT> listResults(Expression<RT> projection) {
        this.queryMixin.addProjection(projection);
        org.hibernate.Query query = this.createQuery(this.toCountRowsString());
        long total = ((Number)query.uniqueResult()).longValue();
        if (total > 0L) {
            QueryModifiers modifiers = this.queryMixin.getMetadata().getModifiers();
            String queryString = this.toQueryString();
            query = this.createQuery(queryString);
            List list = query.list();
            this.reset();
            return new SearchResults(list, modifiers, total);
        }
        this.reset();
        return SearchResults.emptyResults();
    }

    protected void logQuery(String queryString) {
        if (logger.isDebugEnabled()) {
            logger.debug(queryString.replace('\n', ' '));
        }
    }

    protected void reset() {
        this.queryMixin.getMetadata().reset();
        this.entityPaths = null;
        this.constants = null;
    }

    protected String toCountRowsString() {
        return this.buildQueryString(true);
    }

    protected String toQueryString() {
        return this.buildQueryString(false);
    }

    public Tuple uniqueResult(Expression<?> ... args) {
        return (Tuple)this.uniqueResult((Expression<RT>)((Expression)new QTuple(args)));
    }

    public <RT> RT uniqueResult(Expression<RT> expr) {
        org.hibernate.Query query = this.createQuery(expr);
        return (RT)this.uniqueResult(query);
    }

    @Nullable
    private Object uniqueResult(org.hibernate.Query query) {
        this.reset();
        try {
            return query.uniqueResult();
        }
        catch (org.hibernate.NonUniqueResultException e) {
            throw new NonUniqueResultException();
        }
    }

    public <RT> Union<RT> union(ListSubQuery<RT> ... sq) {
        return this.innerUnion((SubQueryExpression<?>[])sq);
    }

    public <RT> Union<RT> union(SubQueryExpression<RT> ... sq) {
        return this.innerUnion(sq);
    }

    public <RT> Union<RT> unionAll(ListSubQuery<RT> ... sq) {
        this.unionAll = true;
        return this.innerUnion((SubQueryExpression<?>[])sq);
    }

    public <RT> Union<RT> unionAll(SubQueryExpression<RT> ... sq) {
        this.unionAll = true;
        return this.innerUnion(sq);
    }

    public <RT> Q union(Path<?> alias, ListSubQuery<RT> ... sq) {
        return (Q)((Object)((AbstractHibernateSQLQuery)((Object)this.from((Expression<?>)UnionUtils.union(sq, alias, (boolean)false)))));
    }

    public <RT> Q union(Path<?> alias, SubQueryExpression<RT> ... sq) {
        return (Q)((Object)((AbstractHibernateSQLQuery)((Object)this.from((Expression<?>)UnionUtils.union(sq, alias, (boolean)false)))));
    }

    public <RT> Q unionAll(Path<?> alias, ListSubQuery<RT> ... sq) {
        return (Q)((Object)((AbstractHibernateSQLQuery)((Object)this.from((Expression<?>)UnionUtils.union(sq, alias, (boolean)true)))));
    }

    public <RT> Q unionAll(Path<?> alias, SubQueryExpression<RT> ... sq) {
        return (Q)((Object)((AbstractHibernateSQLQuery)((Object)this.from((Expression<?>)UnionUtils.union(sq, alias, (boolean)true)))));
    }

    private <RT> Union<RT> innerUnion(SubQueryExpression<?> ... sq) {
        this.queryMixin.getMetadata().setValidate(false);
        if (!this.queryMixin.getMetadata().getJoins().isEmpty()) {
            throw new IllegalArgumentException("Don't mix union and from");
        }
        this.union = UnionUtils.union(sq, (boolean)this.unionAll);
        return new UnionImpl((Query)this, sq[0].getMetadata().getProjection());
    }

    public Q setCacheable(boolean cacheable) {
        this.cacheable = cacheable;
        return (Q)((Object)this);
    }

    public Q setCacheRegion(String cacheRegion) {
        this.cacheRegion = cacheRegion;
        return (Q)((Object)this);
    }

    public Q setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
        return (Q)((Object)this);
    }

    public Q setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        return (Q)((Object)this);
    }

    public Q setTimeout(int timeout) {
        this.timeout = timeout;
        return (Q)((Object)this);
    }
}

