/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.jpa.impl;

import com.google.common.collect.Maps;
import com.mysema.query.jpa.BatooTemplates;
import com.mysema.query.jpa.DataNucleusTemplates;
import com.mysema.query.jpa.EclipseLinkTemplates;
import com.mysema.query.jpa.HQLTemplates;
import com.mysema.query.jpa.JPQLTemplates;
import com.mysema.query.jpa.OpenJPATemplates;
import java.util.Map;
import javax.persistence.EntityManager;

public final class JPAProvider {
    private static final Map<Class<?>, JPQLTemplates> mappings = Maps.newHashMap();

    private static void addMapping(String className, JPQLTemplates templates) {
        try {
            mappings.put(Class.forName(className), templates);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static JPQLTemplates getTemplates(EntityManager em) {
        for (Map.Entry<Class<?>, JPQLTemplates> entry : mappings.entrySet()) {
            if (!entry.getKey().isAssignableFrom(em.getDelegate().getClass())) continue;
            return entry.getValue();
        }
        return JPQLTemplates.DEFAULT;
    }

    private JPAProvider() {
    }

    static {
        JPAProvider.addMapping("org.batoo.jpa.core.impl.manager.EntityManagerImpl", BatooTemplates.DEFAULT);
        JPAProvider.addMapping("org.hibernate.Session", HQLTemplates.DEFAULT);
        JPAProvider.addMapping("org.hibernate.ejb.HibernateEntityManager", HQLTemplates.DEFAULT);
        JPAProvider.addMapping("org.eclipse.persistence.jpa.JpaEntityManager", EclipseLinkTemplates.DEFAULT);
        JPAProvider.addMapping("org.apache.openjpa.persistence.OpenJPAEntityManager", OpenJPATemplates.DEFAULT);
        JPAProvider.addMapping("org.datanucleus.jpa.EntityManagerImpl", DataNucleusTemplates.DEFAULT);
        JPAProvider.addMapping("org.datanucleus.ObjectManager", DataNucleusTemplates.DEFAULT);
        JPAProvider.addMapping("org.datanucleus.ObjectManagerImpl", DataNucleusTemplates.DEFAULT);
    }
}

