/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.jpa;

import com.mysema.query.support.NumberConversion;
import com.mysema.query.support.NumberConversions;
import com.mysema.query.types.Expression;
import com.mysema.query.types.ExpressionUtils;
import com.mysema.query.types.FactoryExpression;
import com.mysema.query.types.Operation;
import com.mysema.query.types.Ops;
import com.mysema.query.types.Path;
import com.mysema.query.types.Template;
import com.mysema.query.types.TemplateExpressionImpl;
import com.mysema.query.types.TemplateFactory;
import javax.persistence.Entity;

public final class Conversions {
    private static final Template ALL = TemplateFactory.DEFAULT.create("{0}.*");

    public static <RT> Expression<RT> convert(Expression<RT> expr) {
        if (Conversions.isAggSumWithConversion(expr) || Conversions.isCountAggConversion(expr)) {
            return new NumberConversion(expr);
        }
        if (expr instanceof FactoryExpression) {
            FactoryExpression factorye = (FactoryExpression)expr;
            for (Expression e : factorye.getArgs()) {
                if (!Conversions.isAggSumWithConversion(e) && !Conversions.isCountAggConversion(expr)) continue;
                return new NumberConversions(factorye);
            }
        }
        return expr;
    }

    public static <RT> Expression<RT> convertForNativeQuery(Expression<RT> expr) {
        if (expr instanceof Path && expr.getType().isAnnotationPresent(Entity.class)) {
            Path path = (Path)expr;
            if (path.getMetadata().getParent() == null) {
                return TemplateExpressionImpl.create((Class)expr.getType(), (Template)ALL, (Object[])new Object[]{expr});
            }
        } else {
            if (Number.class.isAssignableFrom(expr.getType())) {
                return new NumberConversion(expr);
            }
            if (expr instanceof FactoryExpression) {
                FactoryExpression factorye = (FactoryExpression)expr;
                for (Expression e : factorye.getArgs()) {
                    if (!Number.class.isAssignableFrom(e.getType())) continue;
                    return new NumberConversions(factorye);
                }
            }
        }
        return expr;
    }

    private static boolean isAggSumWithConversion(Expression<?> expr) {
        Operation operation;
        Class type;
        if ((expr = ExpressionUtils.extract(expr)) instanceof Operation && ((type = (operation = (Operation)expr).getType()).equals(Float.class) || type.equals(Integer.class) || type.equals(Short.class) || type.equals(Byte.class))) {
            if (operation.getOperator() == Ops.AggOps.SUM_AGG) {
                return true;
            }
            for (Expression e : operation.getArgs()) {
                if (!Conversions.isAggSumWithConversion(e)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isCountAggConversion(Expression<?> expr) {
        if ((expr = ExpressionUtils.extract(expr)) instanceof Operation) {
            Operation operation = (Operation)expr;
            return operation.getOperator() == Ops.AggOps.COUNT_AGG;
        }
        return false;
    }

    private Conversions() {
    }
}

