/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.jpa;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mysema.query.QueryMetadata;
import com.mysema.query.sql.Configuration;
import com.mysema.query.sql.SQLSerializer;
import com.mysema.query.types.Expression;
import com.mysema.query.types.ExpressionUtils;
import com.mysema.query.types.FactoryExpression;
import com.mysema.query.types.Operation;
import com.mysema.query.types.Ops;
import com.mysema.query.types.Path;
import com.mysema.query.types.QTuple;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;

public final class NativeSQLSerializer
extends SQLSerializer {
    public NativeSQLSerializer(Configuration configuration) {
        super(configuration);
    }

    public void serialize(QueryMetadata metadata, boolean forCountRow) {
        int size = metadata.getProjection().size();
        Expression[] args = metadata.getProjection().toArray(new Expression[size]);
        boolean modified = false;
        HashSet<String> used = new HashSet<String>();
        for (int i = 0; i < args.length; ++i) {
            if (args[i] instanceof Path) {
                Path path = (Path)args[i];
                if (used.add(path.getMetadata().getName())) continue;
                args[i] = ExpressionUtils.as((Expression)args[i], (String)("col__" + (i + 1)));
                modified = true;
                continue;
            }
            if (args[i] instanceof FactoryExpression) {
                FactoryExpression factoryExpr = (FactoryExpression)args[i];
                ArrayList fargs = Lists.newArrayList((Iterable)factoryExpr.getArgs());
                for (int j = 0; j < fargs.size(); ++j) {
                    if (this.isAlias((Expression)fargs.get(j)) || ((Expression)fargs.get(j)).toString().contains("*")) continue;
                    fargs.set(j, ExpressionUtils.as((Expression)((Expression)fargs.get(j)), (String)("col__" + (i + 1) + "_" + (j + 1))));
                }
                args[i] = new QTuple(ImmutableList.copyOf((Collection)fargs));
                modified = true;
                continue;
            }
            if (this.isAlias(args[i]) || args[i].toString().contains("*")) continue;
            args[i] = ExpressionUtils.as((Expression)args[i], (String)("col__" + (i + 1)));
            modified = true;
        }
        if (modified) {
            metadata = metadata.clone();
            metadata.clearProjection();
            for (Expression arg : args) {
                metadata.addProjection(arg);
            }
        }
        super.serialize(metadata, forCountRow);
    }

    private boolean isAlias(Expression<?> expr) {
        return expr instanceof Operation && ((Operation)expr).getOperator() == Ops.ALIAS;
    }

    public void visitConstant(Object constant) {
        if (constant instanceof Collection) {
            this.append("(");
            boolean first = true;
            for (Object element : (Collection)constant) {
                if (!first) {
                    this.append(", ");
                }
                this.visitConstant(element);
                first = false;
            }
            this.append(")");
        } else if (!this.getConstantToLabel().containsKey(constant)) {
            String constLabel = String.valueOf(this.getConstantToLabel().size() + 1);
            this.getConstantToLabel().put(constant, constLabel);
            this.append("?" + constLabel);
        } else {
            this.append("?" + (String)this.getConstantToLabel().get(constant));
        }
    }
}

