/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.jpa;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mysema.query.JoinFlag;
import com.mysema.query.QueryMetadata;
import com.mysema.query.jpa.Conversions;
import com.mysema.query.jpa.JPACollectionAnyVisitor;
import com.mysema.query.jpa.JPQLOps;
import com.mysema.query.support.Context;
import com.mysema.query.support.ListAccessVisitor;
import com.mysema.query.support.QueryMixin;
import com.mysema.query.types.CollectionExpression;
import com.mysema.query.types.ConstantImpl;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.ExpressionUtils;
import com.mysema.query.types.Operation;
import com.mysema.query.types.OperationImpl;
import com.mysema.query.types.Path;
import com.mysema.query.types.PathImpl;
import com.mysema.query.types.PathMetadata;
import com.mysema.query.types.PathType;
import com.mysema.query.types.Predicate;
import com.mysema.query.types.Visitor;
import java.util.Map;
import java.util.Set;

public class JPAQueryMixin<T>
extends QueryMixin<T> {
    private final Set<Path<?>> paths = Sets.newHashSet();
    private final Map<Expression<?>, Path<?>> aliases = Maps.newHashMap();
    public static final JoinFlag FETCH = new JoinFlag("fetch ");
    public static final JoinFlag FETCH_ALL_PROPERTIES = new JoinFlag(" fetch all properties");

    public JPAQueryMixin() {
    }

    public JPAQueryMixin(QueryMetadata metadata) {
        super(metadata);
    }

    public JPAQueryMixin(T self, QueryMetadata metadata) {
        super(self, metadata);
    }

    public T fetch() {
        this.addJoinFlag(FETCH);
        return (T)this.getSelf();
    }

    public T fetchAll() {
        this.addJoinFlag(FETCH_ALL_PROPERTIES);
        return (T)this.getSelf();
    }

    protected <D> Expression<D> createAlias(Expression<?> expr, Path<?> alias) {
        this.aliases.put(expr, alias);
        return super.createAlias(expr, alias);
    }

    private <T> Class<T> getElementTypeOrType(Path<T> path) {
        if (path instanceof CollectionExpression) {
            return ((CollectionExpression)path).getParameter(0);
        }
        return path.getType();
    }

    private <T> Path<T> shorten(Path<T> path) {
        PathMetadata metadata = path.getMetadata();
        if (metadata.isRoot()) {
            return path;
        }
        if (this.aliases.containsKey(path)) {
            return this.aliases.get(path);
        }
        if (metadata.getPathType() == PathType.COLLECTION_ANY) {
            return this.shorten(metadata.getParent());
        }
        if (metadata.getParent().getMetadata().isRoot()) {
            Class<T> type = this.getElementTypeOrType(path);
            PathImpl newPath = new PathImpl(type, path.toString().replace('.', '_'));
            this.leftJoin((Expression)path, (Path)newPath);
            return newPath;
        }
        Class<T> type = this.getElementTypeOrType(path);
        Path<T> parent = this.shorten(metadata.getParent());
        PathImpl oldPath = new PathImpl(path.getType(), new PathMetadata(parent, metadata.getElement(), metadata.getPathType()));
        PathImpl newPath = new PathImpl(type, oldPath.toString().replace('.', '_'));
        this.leftJoin((Expression)oldPath, (Path)newPath);
        return newPath;
    }

    public <RT> Expression<RT> convert(Expression<RT> expr, boolean forOrder) {
        Path path;
        PathMetadata metadata;
        if (forOrder && expr instanceof Path && (metadata = (path = (Path)expr).getMetadata()).getParent() != null && !metadata.getParent().getMetadata().isRoot()) {
            Path<T> shortened = this.shorten(metadata.getParent());
            expr = new PathImpl(expr.getType(), new PathMetadata(shortened, metadata.getElement(), metadata.getPathType()));
        }
        return super.convert(Conversions.convert(expr), forOrder);
    }

    protected Predicate normalize(Predicate predicate, boolean where) {
        if (predicate != null) {
            predicate = (Predicate)ExpressionUtils.extract((Expression)predicate);
        }
        if (predicate != null) {
            predicate = (Predicate)predicate.accept((Visitor)JPACollectionAnyVisitor.DEFAULT, (Object)new Context());
            Context context = new Context();
            predicate = (Predicate)predicate.accept((Visitor)ListAccessVisitor.DEFAULT, (Object)context);
            for (int i = 0; i < context.paths.size(); ++i) {
                Path path = (Path)context.paths.get(i);
                if (this.paths.contains(path)) continue;
                this.addCondition(context, i, path, where);
            }
            return predicate;
        }
        return null;
    }

    private void addCondition(Context context, int i, Path<?> path, boolean where) {
        this.paths.add(path);
        EntityPath alias = (EntityPath)context.replacements.get(i);
        this.leftJoin((Expression)path.getMetadata().getParent(), (Path)context.replacements.get(i));
        Operation index = OperationImpl.create(Integer.class, JPQLOps.INDEX, (Expression)alias);
        Object element = path.getMetadata().getElement();
        if (!(element instanceof Expression)) {
            element = ConstantImpl.create((Object)element);
        }
        Predicate condition = ExpressionUtils.eq((Expression)index, (Expression)((Expression)element));
        if (where) {
            super.where(condition);
        } else {
            super.having(condition);
        }
    }
}

