/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.jpa.hibernate.sql;

import com.mysema.commons.lang.CloseableIterator;
import com.mysema.query.DefaultQueryMetadata;
import com.mysema.query.NonUniqueResultException;
import com.mysema.query.QueryMetadata;
import com.mysema.query.QueryModifiers;
import com.mysema.query.SearchResults;
import com.mysema.query.Tuple;
import com.mysema.query.jpa.AbstractSQLQuery;
import com.mysema.query.jpa.FactoryExpressionTransformer;
import com.mysema.query.jpa.NativeSQLSerializer;
import com.mysema.query.jpa.ScrollableResultsIterator;
import com.mysema.query.jpa.hibernate.DefaultSessionHolder;
import com.mysema.query.jpa.hibernate.HibernateUtil;
import com.mysema.query.jpa.hibernate.SessionHolder;
import com.mysema.query.jpa.hibernate.StatelessSessionHolder;
import com.mysema.query.sql.Configuration;
import com.mysema.query.types.Expression;
import com.mysema.query.types.FactoryExpression;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.StatelessSession;
import org.hibernate.transform.ResultTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHibernateSQLQuery<Q extends AbstractHibernateSQLQuery<Q>>
extends AbstractSQLQuery<Q> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractHibernateSQLQuery.class);
    protected Boolean cacheable;
    protected Boolean readOnly;
    protected String cacheRegion;
    @Nullable
    private Map<Object, String> constants;
    @Nullable
    private Map<Expression<?>, String> aliases;
    protected int fetchSize = 0;
    private final SessionHolder session;
    protected final Configuration configuration;
    protected int timeout = 0;

    public AbstractHibernateSQLQuery(Session session, Configuration conf) {
        this(new DefaultSessionHolder(session), conf, (QueryMetadata)new DefaultQueryMetadata());
    }

    public AbstractHibernateSQLQuery(StatelessSession session, Configuration conf) {
        this(new StatelessSessionHolder(session), conf, (QueryMetadata)new DefaultQueryMetadata());
    }

    public AbstractHibernateSQLQuery(SessionHolder session, Configuration conf, QueryMetadata metadata) {
        super(metadata);
        this.session = session;
        this.configuration = conf;
    }

    private String buildQueryString(boolean forCountRow) {
        NativeSQLSerializer serializer = new NativeSQLSerializer(this.configuration, true);
        if (this.union != null) {
            serializer.serializeUnion(this.union, this.queryMixin.getMetadata(), this.unionAll);
        } else {
            serializer.serialize(this.queryMixin.getMetadata(), forCountRow);
        }
        this.constants = serializer.getConstantToLabel();
        this.aliases = serializer.getAliases();
        return serializer.toString();
    }

    public Query createQuery(Expression<?> ... args) {
        this.queryMixin.getMetadata().setValidate(false);
        this.queryMixin.addProjection(args);
        return this.createQuery(this.toQueryString(), false);
    }

    private Query createQuery(String queryString, boolean forCount) {
        this.logQuery(queryString);
        SQLQuery query = this.session.createSQLQuery(queryString);
        HibernateUtil.setConstants((Query)query, this.constants, this.queryMixin.getMetadata().getParams());
        if (!forCount) {
            List projection = this.queryMixin.getMetadata().getProjection();
            Expression proj = (Expression)projection.get(0);
            if (proj instanceof FactoryExpression) {
                for (Expression expr : ((FactoryExpression)proj).getArgs()) {
                    if (this.isEntityExpression(expr)) {
                        query.addEntity(this.extractEntityExpression(expr).toString(), expr.getType());
                        continue;
                    }
                    if (!this.aliases.containsKey(expr)) continue;
                    query.addScalar(this.aliases.get(expr));
                }
            } else if (this.isEntityExpression(proj)) {
                query.addEntity(this.extractEntityExpression(proj).toString(), proj.getType());
            } else if (this.aliases.containsKey(proj)) {
                query.addScalar(this.aliases.get(proj));
            }
            if (projection.size() == 1 && proj instanceof FactoryExpression) {
                query.setResultTransformer((ResultTransformer)new FactoryExpressionTransformer((FactoryExpression)proj));
            }
        }
        if (this.fetchSize > 0) {
            query.setFetchSize(this.fetchSize);
        }
        if (this.timeout > 0) {
            query.setTimeout(this.timeout);
        }
        if (this.cacheable != null) {
            query.setCacheable(this.cacheable.booleanValue());
        }
        if (this.cacheRegion != null) {
            query.setCacheRegion(this.cacheRegion);
        }
        if (this.readOnly != null) {
            query.setReadOnly(this.readOnly.booleanValue());
        }
        return query;
    }

    public List<Tuple> list(Expression<?> ... projection) {
        return this.list((Expression<RT>)this.queryMixin.createProjection(projection));
    }

    public <RT> List<RT> list(Expression<RT> projection) {
        Query query = this.createQuery(projection);
        this.reset();
        return query.list();
    }

    public CloseableIterator<Tuple> iterate(Expression<?> ... args) {
        return this.iterate((Expression<RT>)this.queryMixin.createProjection(args));
    }

    public <RT> CloseableIterator<RT> iterate(Expression<RT> projection) {
        Query query = this.createQuery(projection);
        this.reset();
        ScrollableResults results = query.scroll(ScrollMode.FORWARD_ONLY);
        return new ScrollableResultsIterator(results);
    }

    public SearchResults<Tuple> listResults(Expression<?> ... args) {
        return this.listResults((Expression<RT>)this.queryMixin.createProjection(args));
    }

    public <RT> SearchResults<RT> listResults(Expression<RT> projection) {
        this.queryMixin.addProjection(projection);
        Query query = this.createQuery(this.toCountRowsString(), true);
        long total = ((Number)query.uniqueResult()).longValue();
        if (total > 0L) {
            QueryModifiers modifiers = this.queryMixin.getMetadata().getModifiers();
            String queryString = this.toQueryString();
            query = this.createQuery(queryString, false);
            List list = query.list();
            this.reset();
            return new SearchResults(list, modifiers, total);
        }
        this.reset();
        return SearchResults.emptyResults();
    }

    protected void logQuery(String queryString) {
        if (logger.isDebugEnabled()) {
            logger.debug(queryString.replace('\n', ' '));
        }
    }

    protected void reset() {
        this.queryMixin.getMetadata().reset();
        this.constants = null;
    }

    protected String toCountRowsString() {
        return this.buildQueryString(true);
    }

    protected String toQueryString() {
        return this.buildQueryString(false);
    }

    public Tuple uniqueResult(Expression<?> ... args) {
        return (Tuple)this.uniqueResult((Expression<RT>)this.queryMixin.createProjection(args));
    }

    public <RT> RT uniqueResult(Expression<RT> expr) {
        Query query = this.createQuery(expr);
        return (RT)this.uniqueResult(query);
    }

    @Nullable
    private Object uniqueResult(Query query) {
        this.reset();
        try {
            return query.uniqueResult();
        }
        catch (org.hibernate.NonUniqueResultException e) {
            throw new NonUniqueResultException();
        }
    }

    public Q setCacheable(boolean cacheable) {
        this.cacheable = cacheable;
        return (Q)((Object)this);
    }

    public Q setCacheRegion(String cacheRegion) {
        this.cacheRegion = cacheRegion;
        return (Q)((Object)this);
    }

    public Q setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
        return (Q)((Object)this);
    }

    public Q setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        return (Q)((Object)this);
    }

    public Q setTimeout(int timeout) {
        this.timeout = timeout;
        return (Q)((Object)this);
    }
}

