/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.jpa;

import com.mysema.query.JoinFlag;
import com.mysema.query.Query;
import com.mysema.query.QueryFlag;
import com.mysema.query.QueryMetadata;
import com.mysema.query.jpa.Conversions;
import com.mysema.query.sql.ForeignKey;
import com.mysema.query.sql.RelationalFunctionCall;
import com.mysema.query.sql.RelationalPath;
import com.mysema.query.sql.SQLCommonQuery;
import com.mysema.query.sql.SQLOps;
import com.mysema.query.sql.SQLTemplates;
import com.mysema.query.sql.Union;
import com.mysema.query.sql.UnionImpl;
import com.mysema.query.sql.UnionUtils;
import com.mysema.query.sql.WithBuilder;
import com.mysema.query.support.Expressions;
import com.mysema.query.support.ProjectableQuery;
import com.mysema.query.support.QueryMixin;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.ExpressionUtils;
import com.mysema.query.types.Operation;
import com.mysema.query.types.OperationImpl;
import com.mysema.query.types.Operator;
import com.mysema.query.types.Path;
import com.mysema.query.types.Predicate;
import com.mysema.query.types.SubQueryExpression;
import com.mysema.query.types.TemplateExpression;
import com.mysema.query.types.expr.SimpleExpression;
import com.mysema.query.types.expr.Wildcard;
import com.mysema.query.types.query.ListSubQuery;
import com.mysema.query.types.template.NumberTemplate;
import com.mysema.query.types.template.SimpleTemplate;
import javax.annotation.Nullable;
import javax.persistence.Entity;

public abstract class AbstractSQLQuery<T extends AbstractSQLQuery<T>>
extends ProjectableQuery<T>
implements SQLCommonQuery<T> {
    protected final QueryMixin<T> queryMixin;
    @Nullable
    protected Expression<?> union;
    protected boolean unionAll;

    public AbstractSQLQuery(QueryMetadata metadata) {
        super(new NativeQueryMixin(metadata));
        this.queryMixin = ((ProjectableQuery)this).queryMixin;
        this.queryMixin.setSelf((Object)this);
    }

    protected boolean isEntityExpression(Expression<?> expr) {
        return expr instanceof EntityPath || expr.getType().isAnnotationPresent(Entity.class);
    }

    protected Expression<?> extractEntityExpression(Expression<?> expr) {
        if (expr instanceof Operation) {
            return ((Operation)expr).getArg(0);
        }
        if (expr instanceof TemplateExpression) {
            return (Expression)((TemplateExpression)expr).getArg(0);
        }
        return expr;
    }

    public long count() {
        Number number = (Number)this.uniqueResult((Expression)Wildcard.countAsInt);
        return number.longValue();
    }

    public boolean exists() {
        return ((AbstractSQLQuery)this.limit(1L)).uniqueResult((Expression)NumberTemplate.ONE) != null;
    }

    public T from(Expression<?> arg) {
        return (T)((Object)((AbstractSQLQuery)((Object)this.queryMixin.from(arg))));
    }

    public T from(Expression<?> ... args) {
        return (T)((Object)((AbstractSQLQuery)((Object)this.queryMixin.from(args))));
    }

    public T from(SubQueryExpression<?> subQuery, Path<?> alias) {
        return (T)((Object)((AbstractSQLQuery)((Object)this.queryMixin.from(ExpressionUtils.as(subQuery, alias)))));
    }

    public T fullJoin(EntityPath<?> o) {
        return (T)((Object)((AbstractSQLQuery)((Object)this.queryMixin.fullJoin(o))));
    }

    public <E> T fullJoin(RelationalFunctionCall<E> target, Path<E> alias) {
        return (T)((Object)((AbstractSQLQuery)((Object)this.queryMixin.fullJoin(target, alias))));
    }

    public <E> T fullJoin(ForeignKey<E> key, RelationalPath<E> entity) {
        return ((AbstractSQLQuery)((Object)this.queryMixin.fullJoin(entity))).on(key.on(entity));
    }

    public T fullJoin(SubQueryExpression<?> o, Path<?> alias) {
        return (T)((Object)((AbstractSQLQuery)((Object)this.queryMixin.fullJoin(o, alias))));
    }

    public QueryMetadata getMetadata() {
        return this.queryMixin.getMetadata();
    }

    public T innerJoin(EntityPath<?> o) {
        return (T)((Object)((AbstractSQLQuery)((Object)this.queryMixin.innerJoin(o))));
    }

    public <E> T innerJoin(RelationalFunctionCall<E> target, Path<E> alias) {
        return (T)((Object)((AbstractSQLQuery)((Object)this.queryMixin.innerJoin(target, alias))));
    }

    public <E> T innerJoin(ForeignKey<E> key, RelationalPath<E> entity) {
        return ((AbstractSQLQuery)((Object)this.queryMixin.innerJoin(entity))).on(key.on(entity));
    }

    public T innerJoin(SubQueryExpression<?> o, Path<?> alias) {
        return (T)((Object)((AbstractSQLQuery)((Object)this.queryMixin.innerJoin(o, alias))));
    }

    public T join(EntityPath<?> o) {
        return (T)((Object)((AbstractSQLQuery)((Object)this.queryMixin.join(o))));
    }

    public <E> T join(RelationalFunctionCall<E> target, Path<E> alias) {
        return (T)((Object)((AbstractSQLQuery)((Object)this.queryMixin.join(target, alias))));
    }

    public <E> T join(ForeignKey<E> key, RelationalPath<E> entity) {
        return ((AbstractSQLQuery)((Object)this.queryMixin.join(entity))).on(key.on(entity));
    }

    public T join(SubQueryExpression<?> o, Path<?> alias) {
        return (T)((Object)((AbstractSQLQuery)((Object)this.queryMixin.join(o, alias))));
    }

    public T leftJoin(EntityPath<?> o) {
        return (T)((Object)((AbstractSQLQuery)((Object)this.queryMixin.leftJoin(o))));
    }

    public <E> T leftJoin(RelationalFunctionCall<E> target, Path<E> alias) {
        return (T)((Object)((AbstractSQLQuery)((Object)this.queryMixin.leftJoin(target, alias))));
    }

    public <E> T leftJoin(ForeignKey<E> key, RelationalPath<E> entity) {
        return ((AbstractSQLQuery)((Object)this.queryMixin.innerJoin(entity))).on(key.on(entity));
    }

    public T leftJoin(SubQueryExpression<?> o, Path<?> alias) {
        return (T)((Object)((AbstractSQLQuery)((Object)this.queryMixin.leftJoin(o, alias))));
    }

    public T on(Predicate condition) {
        return (T)((Object)((AbstractSQLQuery)((Object)this.queryMixin.on(condition))));
    }

    public T on(Predicate ... conditions) {
        return (T)((Object)((AbstractSQLQuery)((Object)this.queryMixin.on(conditions))));
    }

    public T rightJoin(EntityPath<?> o) {
        return (T)((Object)((AbstractSQLQuery)((Object)this.queryMixin.rightJoin(o))));
    }

    public <E> T rightJoin(RelationalFunctionCall<E> target, Path<E> alias) {
        return (T)((Object)((AbstractSQLQuery)((Object)this.queryMixin.rightJoin(target, alias))));
    }

    public <E> T rightJoin(ForeignKey<E> key, RelationalPath<E> entity) {
        return ((AbstractSQLQuery)((Object)this.queryMixin.innerJoin(entity))).on(key.on(entity));
    }

    public T rightJoin(SubQueryExpression<?> o, Path<?> alias) {
        return (T)((Object)((AbstractSQLQuery)((Object)this.queryMixin.rightJoin(o, alias))));
    }

    public <RT> Union<RT> union(ListSubQuery<RT> ... sq) {
        return this.innerUnion((SubQueryExpression<?>[])sq);
    }

    public <RT> Union<RT> union(SubQueryExpression<RT> ... sq) {
        return this.innerUnion(sq);
    }

    public <RT> Union<RT> unionAll(ListSubQuery<RT> ... sq) {
        this.unionAll = true;
        return this.innerUnion((SubQueryExpression<?>[])sq);
    }

    public <RT> Union<RT> unionAll(SubQueryExpression<RT> ... sq) {
        this.unionAll = true;
        return this.innerUnion(sq);
    }

    public <RT> T union(Path<?> alias, ListSubQuery<RT> ... sq) {
        return this.from((Expression<?>)UnionUtils.union(sq, alias, (boolean)false));
    }

    public <RT> T union(Path<?> alias, SubQueryExpression<RT> ... sq) {
        return this.from((Expression<?>)UnionUtils.union(sq, alias, (boolean)false));
    }

    public <RT> T unionAll(Path<?> alias, ListSubQuery<RT> ... sq) {
        return this.from((Expression<?>)UnionUtils.union(sq, alias, (boolean)true));
    }

    public <RT> T unionAll(Path<?> alias, SubQueryExpression<RT> ... sq) {
        return this.from((Expression<?>)UnionUtils.union(sq, alias, (boolean)true));
    }

    public T withRecursive(Path<?> alias, SubQueryExpression<?> query) {
        this.queryMixin.addFlag(new QueryFlag(QueryFlag.Position.WITH, SQLTemplates.RECURSIVE));
        return (T)this.with((Path)alias, (SubQueryExpression)query);
    }

    public T withRecursive(Path<?> alias, Expression<?> query) {
        this.queryMixin.addFlag(new QueryFlag(QueryFlag.Position.WITH, SQLTemplates.RECURSIVE));
        return (T)this.with((Path)alias, (Expression)query);
    }

    public WithBuilder<T> withRecursive(Path<?> alias, Path<?> ... columns) {
        this.queryMixin.addFlag(new QueryFlag(QueryFlag.Position.WITH, SQLTemplates.RECURSIVE));
        return this.with(alias, columns);
    }

    public T with(Path<?> alias, Expression<?> query) {
        Operation expr = OperationImpl.create((Class)alias.getType(), (Operator)SQLOps.WITH_ALIAS, alias, query);
        return (T)((Object)((AbstractSQLQuery)((Object)this.queryMixin.addFlag(new QueryFlag(QueryFlag.Position.WITH, (Expression)expr)))));
    }

    public WithBuilder<T> with(Path<?> alias, Path<?> ... columns) {
        Expression columnsCombined = ExpressionUtils.list(Object.class, columns);
        SimpleExpression aliasCombined = Expressions.operation((Class)alias.getType(), (Operator)SQLOps.WITH_COLUMNS, (Expression[])new Expression[]{alias, columnsCombined});
        return new WithBuilder(this.queryMixin, (Expression)aliasCombined);
    }

    public T with(Path<?> alias, SubQueryExpression<?> query) {
        Operation expr = OperationImpl.create((Class)alias.getType(), (Operator)SQLOps.WITH_ALIAS, alias, query);
        return (T)((Object)((AbstractSQLQuery)((Object)this.queryMixin.addFlag(new QueryFlag(QueryFlag.Position.WITH, (Expression)expr)))));
    }

    protected <RT> Union<RT> innerUnion(SubQueryExpression<?> ... sq) {
        this.queryMixin.getMetadata().setValidate(false);
        if (!this.queryMixin.getMetadata().getJoins().isEmpty()) {
            throw new IllegalArgumentException("Don't mix union and from");
        }
        this.union = UnionUtils.union(sq, (boolean)this.unionAll);
        return new UnionImpl((Query)this, sq[0].getMetadata().getProjection());
    }

    public T addJoinFlag(String flag) {
        return (T)this.addJoinFlag(flag, JoinFlag.Position.BEFORE_TARGET);
    }

    public T addJoinFlag(String flag, JoinFlag.Position position) {
        this.queryMixin.addJoinFlag(new JoinFlag(flag, position));
        return (T)((Object)this);
    }

    public T addFlag(QueryFlag.Position position, String prefix, Expression<?> expr) {
        SimpleExpression flag = SimpleTemplate.create((Class)expr.getType(), (String)(prefix + "{0}"), expr);
        return (T)((Object)((AbstractSQLQuery)((Object)this.queryMixin.addFlag(new QueryFlag(position, (Expression)flag)))));
    }

    public T addFlag(QueryFlag.Position position, String flag) {
        return (T)((Object)((AbstractSQLQuery)((Object)this.queryMixin.addFlag(new QueryFlag(position, flag)))));
    }

    public T addFlag(QueryFlag.Position position, Expression<?> flag) {
        return (T)((Object)((AbstractSQLQuery)((Object)this.queryMixin.addFlag(new QueryFlag(position, flag)))));
    }

    private static final class NativeQueryMixin<T>
    extends QueryMixin<T> {
        private NativeQueryMixin(QueryMetadata metadata) {
            super(metadata, false);
        }

        public <RT> Expression<RT> convert(Expression<RT> expr, boolean forOrder) {
            return Conversions.convertForNativeQuery(super.convert(expr, forOrder));
        }
    }
}

