/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.jpa;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mysema.query.QueryMetadata;
import com.mysema.query.sql.ColumnMetadata;
import com.mysema.query.sql.Configuration;
import com.mysema.query.sql.RelationalPath;
import com.mysema.query.sql.SQLOps;
import com.mysema.query.sql.SQLSerializer;
import com.mysema.query.types.Expression;
import com.mysema.query.types.ExpressionUtils;
import com.mysema.query.types.FactoryExpression;
import com.mysema.query.types.Operation;
import com.mysema.query.types.Operator;
import com.mysema.query.types.Ops;
import com.mysema.query.types.Path;
import com.mysema.query.types.QTuple;
import com.mysema.query.types.TemplateExpression;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public final class NativeSQLSerializer
extends SQLSerializer {
    private final Map<Expression<?>, String> aliases = Maps.newHashMap();
    private final boolean wrapEntityProjections;

    public NativeSQLSerializer(Configuration configuration) {
        this(configuration, false);
    }

    public NativeSQLSerializer(Configuration configuration, boolean wrapEntityProjections) {
        super(configuration);
        this.wrapEntityProjections = wrapEntityProjections;
    }

    private boolean isAlias(Expression<?> expr) {
        return expr instanceof Operation && ((Operation)expr).getOperator() == Ops.ALIAS;
    }

    public Map<Expression<?>, String> getAliases() {
        return this.aliases;
    }

    private boolean isAllExpression(Expression<?> expr) {
        if (expr instanceof Operation) {
            return ((Operation)expr).getOperator() == SQLOps.ALL;
        }
        if (expr instanceof TemplateExpression) {
            return ((TemplateExpression)expr).getTemplate().toString().equals("*");
        }
        return false;
    }

    public void serialize(QueryMetadata metadata, boolean forCountRow) {
        int size = metadata.getProjection().size();
        Expression[] args = metadata.getProjection().toArray(new Expression[size]);
        boolean modified = false;
        HashSet<String> used = new HashSet<String>();
        for (int i = 0; i < args.length; ++i) {
            if (args[i] instanceof Path) {
                Path path = (Path)args[i];
                if (!used.add(path.getMetadata().getName())) {
                    String alias = "col__" + (i + 1);
                    this.aliases.put(args[i], alias);
                    args[i] = ExpressionUtils.as((Expression)args[i], (String)alias);
                    modified = true;
                    continue;
                }
                this.aliases.put((Expression<?>)path, ColumnMetadata.getName((Path)path));
                continue;
            }
            if (args[i] instanceof FactoryExpression) {
                FactoryExpression factoryExpr = (FactoryExpression)args[i];
                ArrayList fargs = Lists.newArrayList((Iterable)factoryExpr.getArgs());
                for (int j = 0; j < fargs.size(); ++j) {
                    if (fargs.get(j) instanceof Path) {
                        Path path = (Path)fargs.get(j);
                        String columnName = ColumnMetadata.getName((Path)path);
                        if (!used.add(columnName)) {
                            String alias = "col__" + (i + 1) + "_" + (j + 1);
                            this.aliases.put((Expression<?>)path, alias);
                            fargs.set(j, ExpressionUtils.as((Expression)((Expression)fargs.get(j)), (String)alias));
                            continue;
                        }
                        this.aliases.put((Expression<?>)path, columnName);
                        continue;
                    }
                    if (this.isAlias((Expression)fargs.get(j))) {
                        Operation operation = (Operation)fargs.get(j);
                        this.aliases.put((Expression<?>)operation, operation.getArg(1).toString());
                        continue;
                    }
                    if (this.isAllExpression((Expression)fargs.get(j))) continue;
                    String alias = "col__" + (i + 1) + "_" + (j + 1);
                    this.aliases.put((Expression<?>)fargs.get(j), alias);
                    fargs.set(j, ExpressionUtils.as((Expression)((Expression)fargs.get(j)), (String)alias));
                }
                args[i] = new QTuple(ImmutableList.copyOf((Collection)fargs));
                modified = true;
                continue;
            }
            if (this.isAlias(args[i])) {
                Operation operation = (Operation)args[i];
                this.aliases.put((Expression<?>)operation, operation.getArg(1).toString());
                continue;
            }
            if (this.isAllExpression(args[i])) continue;
            String alias = "col__" + (i + 1);
            this.aliases.put(args[i], alias);
            args[i] = ExpressionUtils.as((Expression)args[i], (String)alias);
            modified = true;
        }
        if (modified) {
            metadata = metadata.clone();
            metadata.clearProjection();
            for (Expression arg : args) {
                metadata.addProjection(arg);
            }
        }
        super.serialize(metadata, forCountRow);
    }

    public void visitConstant(Object constant) {
        if (constant instanceof Collection) {
            this.append("(");
            boolean first = true;
            for (Object element : (Collection)constant) {
                if (!first) {
                    this.append(", ");
                }
                this.visitConstant(element);
                first = false;
            }
            this.append(")");
        } else if (!this.getConstantToLabel().containsKey(constant)) {
            String constLabel = String.valueOf(this.getConstantToLabel().size() + 1);
            this.getConstantToLabel().put(constant, constLabel);
            this.append("?" + constLabel);
        } else {
            this.append("?" + (String)this.getConstantToLabel().get(constant));
        }
    }

    protected void visitOperation(Class<?> type, Operator<?> operator, List<? extends Expression<?>> args) {
        if (operator == SQLOps.ALL && !RelationalPath.class.isInstance(args.get(0)) && this.wrapEntityProjections) {
            this.append("{");
            super.visitOperation(type, operator, args);
            this.append("}");
        } else {
            super.visitOperation(type, operator, args);
        }
    }
}

