/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.jpa.hibernate.sql;

import com.mysema.commons.lang.CloseableIterator;
import com.mysema.query.DefaultQueryMetadata;
import com.mysema.query.NonUniqueResultException;
import com.mysema.query.QueryMetadata;
import com.mysema.query.QueryModifiers;
import com.mysema.query.SearchResults;
import com.mysema.query.jpa.AbstractSQLQuery;
import com.mysema.query.jpa.FactoryExpressionTransformer;
import com.mysema.query.jpa.NativeSQLSerializer;
import com.mysema.query.jpa.ScrollableResultsIterator;
import com.mysema.query.jpa.hibernate.DefaultSessionHolder;
import com.mysema.query.jpa.hibernate.HibernateUtil;
import com.mysema.query.jpa.hibernate.SessionHolder;
import com.mysema.query.jpa.hibernate.StatelessSessionHolder;
import com.mysema.query.sql.Configuration;
import com.mysema.query.sql.SQLSerializer;
import com.mysema.query.types.Expression;
import com.mysema.query.types.FactoryExpression;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.StatelessSession;
import org.hibernate.transform.ResultTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHibernateSQLQuery<Q extends AbstractHibernateSQLQuery<Q>>
extends AbstractSQLQuery<Q> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractHibernateSQLQuery.class);
    protected Boolean cacheable;
    protected Boolean readOnly;
    protected String cacheRegion;
    protected int fetchSize = 0;
    private final SessionHolder session;
    protected int timeout = 0;

    public AbstractHibernateSQLQuery(Session session, Configuration conf) {
        this(new DefaultSessionHolder(session), conf, (QueryMetadata)new DefaultQueryMetadata());
    }

    public AbstractHibernateSQLQuery(StatelessSession session, Configuration conf) {
        this(new StatelessSessionHolder(session), conf, (QueryMetadata)new DefaultQueryMetadata());
    }

    public AbstractHibernateSQLQuery(SessionHolder session, Configuration conf, QueryMetadata metadata) {
        super(metadata, conf);
        this.session = session;
    }

    public Query createQuery(Expression<?> ... args) {
        this.queryMixin.getMetadata().setValidate(false);
        this.queryMixin.addProjection(args);
        return this.createQuery(false);
    }

    private Query createQuery(boolean forCount) {
        NativeSQLSerializer serializer = (NativeSQLSerializer)this.serialize(forCount);
        String queryString = serializer.toString();
        this.logQuery(queryString);
        SQLQuery query = this.session.createSQLQuery(queryString);
        HibernateUtil.setConstants((Query)query, serializer.getConstantToLabel(), this.queryMixin.getMetadata().getParams());
        if (!forCount) {
            Map<Expression<?>, String> aliases = serializer.getAliases();
            List projection = this.queryMixin.getMetadata().getProjection();
            Expression proj = (Expression)projection.get(0);
            if (proj instanceof FactoryExpression) {
                for (Expression expr : ((FactoryExpression)proj).getArgs()) {
                    if (this.isEntityExpression(expr)) {
                        query.addEntity(this.extractEntityExpression(expr).toString(), expr.getType());
                        continue;
                    }
                    if (!aliases.containsKey(expr)) continue;
                    query.addScalar(aliases.get(expr));
                }
            } else if (this.isEntityExpression(proj)) {
                query.addEntity(this.extractEntityExpression(proj).toString(), proj.getType());
            } else if (aliases.containsKey(proj)) {
                query.addScalar(aliases.get(proj));
            }
            if (projection.size() == 1 && proj instanceof FactoryExpression) {
                query.setResultTransformer((ResultTransformer)new FactoryExpressionTransformer((FactoryExpression)proj));
            }
        }
        if (this.fetchSize > 0) {
            query.setFetchSize(this.fetchSize);
        }
        if (this.timeout > 0) {
            query.setTimeout(this.timeout);
        }
        if (this.cacheable != null) {
            query.setCacheable(this.cacheable.booleanValue());
        }
        if (this.cacheRegion != null) {
            query.setCacheRegion(this.cacheRegion);
        }
        if (this.readOnly != null) {
            query.setReadOnly(this.readOnly.booleanValue());
        }
        return query;
    }

    protected SQLSerializer createSerializer() {
        return new NativeSQLSerializer(this.configuration, true);
    }

    public <RT> List<RT> list(Expression<RT> projection) {
        Query query = this.createQuery(projection);
        this.reset();
        return query.list();
    }

    public <RT> CloseableIterator<RT> iterate(Expression<RT> projection) {
        Query query = this.createQuery(projection);
        this.reset();
        ScrollableResults results = query.scroll(ScrollMode.FORWARD_ONLY);
        return new ScrollableResultsIterator(results);
    }

    public <RT> SearchResults<RT> listResults(Expression<RT> projection) {
        this.queryMixin.addProjection(projection);
        Query query = this.createQuery(true);
        long total = ((Number)query.uniqueResult()).longValue();
        if (total > 0L) {
            QueryModifiers modifiers = this.queryMixin.getMetadata().getModifiers();
            query = this.createQuery(false);
            List list = query.list();
            this.reset();
            return new SearchResults(list, modifiers, total);
        }
        this.reset();
        return SearchResults.emptyResults();
    }

    protected void logQuery(String queryString) {
        if (logger.isDebugEnabled()) {
            logger.debug(queryString.replace('\n', ' '));
        }
    }

    protected void reset() {
        this.queryMixin.getMetadata().reset();
    }

    public <RT> RT uniqueResult(Expression<RT> expr) {
        Query query = this.createQuery(expr);
        return (RT)this.uniqueResult(query);
    }

    @Nullable
    private Object uniqueResult(Query query) {
        this.reset();
        try {
            return query.uniqueResult();
        }
        catch (org.hibernate.NonUniqueResultException e) {
            throw new NonUniqueResultException();
        }
    }

    public Q setCacheable(boolean cacheable) {
        this.cacheable = cacheable;
        return (Q)((Object)this);
    }

    public Q setCacheRegion(String cacheRegion) {
        this.cacheRegion = cacheRegion;
        return (Q)((Object)this);
    }

    public Q setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
        return (Q)((Object)this);
    }

    public Q setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        return (Q)((Object)this);
    }

    public Q setTimeout(int timeout) {
        this.timeout = timeout;
        return (Q)((Object)this);
    }

    protected void clone(Q query) {
        super.clone(query);
        this.cacheable = ((AbstractHibernateSQLQuery)((Object)query)).cacheable;
        this.cacheRegion = ((AbstractHibernateSQLQuery)((Object)query)).cacheRegion;
        this.fetchSize = ((AbstractHibernateSQLQuery)((Object)query)).fetchSize;
        this.readOnly = ((AbstractHibernateSQLQuery)((Object)query)).readOnly;
        this.timeout = ((AbstractHibernateSQLQuery)((Object)query)).timeout;
    }

    protected abstract Q clone(SessionHolder var1);

    public Q clone(Session session) {
        return this.clone(new DefaultSessionHolder(session));
    }

    public Q clone(StatelessSession statelessSession) {
        return this.clone(new StatelessSessionHolder(statelessSession));
    }

    public Q clone() {
        return this.clone(this.session);
    }
}

