/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.jpa;

import com.mysema.query.QueryMetadata;
import com.mysema.query.jpa.Conversions;
import com.mysema.query.sql.Configuration;
import com.mysema.query.sql.ProjectableSQLQuery;
import com.mysema.query.support.QueryMixin;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.Operation;
import com.mysema.query.types.TemplateExpression;
import javax.persistence.Entity;

public abstract class AbstractSQLQuery<Q extends AbstractSQLQuery<Q>>
extends ProjectableSQLQuery<Q> {
    public AbstractSQLQuery(QueryMetadata metadata, Configuration configuration) {
        super(new NativeQueryMixin(metadata), configuration);
        this.queryMixin.setSelf((Object)this);
    }

    protected boolean isEntityExpression(Expression<?> expr) {
        return expr instanceof EntityPath || expr.getType().isAnnotationPresent(Entity.class);
    }

    protected Expression<?> extractEntityExpression(Expression<?> expr) {
        if (expr instanceof Operation) {
            return ((Operation)expr).getArg(0);
        }
        if (expr instanceof TemplateExpression) {
            return (Expression)((TemplateExpression)expr).getArg(0);
        }
        return expr;
    }

    private static final class NativeQueryMixin<T>
    extends QueryMixin<T> {
        private NativeQueryMixin(QueryMetadata metadata) {
            super(metadata, false);
        }

        public <RT> Expression<RT> convert(Expression<RT> expr, boolean forOrder) {
            return Conversions.convertForNativeQuery(super.convert(expr, forOrder));
        }
    }
}

