/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.jpa;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.mysema.query.JoinExpression;
import com.mysema.query.QueryMetadata;
import com.mysema.query.sql.ColumnMetadata;
import com.mysema.query.sql.Configuration;
import com.mysema.query.sql.RelationalPath;
import com.mysema.query.sql.SQLOps;
import com.mysema.query.sql.SQLSerializer;
import com.mysema.query.sql.SQLTemplates;
import com.mysema.query.types.Expression;
import com.mysema.query.types.ExpressionUtils;
import com.mysema.query.types.FactoryExpression;
import com.mysema.query.types.Operation;
import com.mysema.query.types.Operator;
import com.mysema.query.types.Ops;
import com.mysema.query.types.Path;
import com.mysema.query.types.QTuple;
import com.mysema.query.types.TemplateExpression;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Table;

public final class NativeSQLSerializer
extends SQLSerializer {
    private final ListMultimap<Expression<?>, String> aliases = ArrayListMultimap.create();
    private final boolean wrapEntityProjections;

    public NativeSQLSerializer(Configuration configuration) {
        this(configuration, false);
    }

    public NativeSQLSerializer(Configuration configuration, boolean wrapEntityProjections) {
        super(configuration);
        this.wrapEntityProjections = wrapEntityProjections;
    }

    protected void appendAsColumnName(Path<?> path, boolean precededByDot) {
        if (path.getAnnotatedElement().isAnnotationPresent(Column.class)) {
            SQLTemplates templates = this.getTemplates();
            Column column = path.getAnnotatedElement().getAnnotation(Column.class);
            this.append(templates.quoteIdentifier(column.name(), precededByDot));
        } else {
            super.appendAsColumnName(path, precededByDot);
        }
    }

    protected void handleJoinTarget(JoinExpression je) {
        SQLTemplates templates = this.getTemplates();
        Class type = je.getTarget().getType();
        if (type.isAnnotationPresent(Table.class) && templates.isSupportsAlias()) {
            boolean precededByDot;
            Table table = type.getAnnotation(Table.class);
            if (!table.schema().isEmpty() && templates.isPrintSchema()) {
                this.appendSchemaName(table.schema());
                this.append(".");
                precededByDot = true;
            } else {
                precededByDot = false;
            }
            this.appendTableName(table.name(), precededByDot);
            this.append(templates.getTableAlias());
        }
        super.handleJoinTarget(je);
    }

    private boolean isAlias(Expression<?> expr) {
        return expr instanceof Operation && ((Operation)expr).getOperator() == Ops.ALIAS;
    }

    public ListMultimap<Expression<?>, String> getAliases() {
        return this.aliases;
    }

    private boolean isAllExpression(Expression<?> expr) {
        if (expr instanceof Operation) {
            return ((Operation)expr).getOperator() == SQLOps.ALL;
        }
        if (expr instanceof TemplateExpression) {
            return ((TemplateExpression)expr).getTemplate().toString().equals("*");
        }
        return false;
    }

    public void serialize(QueryMetadata metadata, boolean forCountRow) {
        int size = metadata.getProjection().size();
        Expression[] args = metadata.getProjection().toArray(new Expression[size]);
        boolean modified = false;
        HashSet<String> used = new HashSet<String>();
        for (int i = 0; i < args.length; ++i) {
            if (args[i] instanceof Path) {
                Path path = (Path)args[i];
                if (!used.add(path.getMetadata().getName())) {
                    String alias = "col__" + (i + 1);
                    this.aliases.put((Object)args[i], (Object)alias);
                    args[i] = ExpressionUtils.as((Expression)args[i], (String)alias);
                    modified = true;
                    continue;
                }
                if (path.getAnnotatedElement().isAnnotationPresent(Column.class)) {
                    this.aliases.put((Object)path, (Object)path.getAnnotatedElement().getAnnotation(Column.class).name());
                    continue;
                }
                this.aliases.put((Object)path, (Object)ColumnMetadata.getName((Path)path));
                continue;
            }
            if (args[i] instanceof FactoryExpression) {
                FactoryExpression factoryExpr = (FactoryExpression)args[i];
                ArrayList fargs = Lists.newArrayList((Iterable)factoryExpr.getArgs());
                for (int j = 0; j < fargs.size(); ++j) {
                    if (fargs.get(j) instanceof Path) {
                        Path path = (Path)fargs.get(j);
                        String columnName = path.getAnnotatedElement().isAnnotationPresent(Column.class) ? path.getAnnotatedElement().getAnnotation(Column.class).name() : ColumnMetadata.getName((Path)path);
                        if (!used.add(columnName)) {
                            String alias = "col__" + (i + 1) + "_" + (j + 1);
                            this.aliases.put((Object)path, (Object)alias);
                            fargs.set(j, ExpressionUtils.as((Expression)((Expression)fargs.get(j)), (String)alias));
                            continue;
                        }
                        this.aliases.put((Object)path, (Object)columnName);
                        continue;
                    }
                    if (this.isAlias((Expression)fargs.get(j))) {
                        Operation operation = (Operation)fargs.get(j);
                        this.aliases.put((Object)operation, (Object)operation.getArg(1).toString());
                        continue;
                    }
                    if (this.isAllExpression((Expression)fargs.get(j))) continue;
                    String alias = "col__" + (i + 1) + "_" + (j + 1);
                    this.aliases.put(fargs.get(j), (Object)alias);
                    fargs.set(j, ExpressionUtils.as((Expression)((Expression)fargs.get(j)), (String)alias));
                }
                args[i] = new QTuple(ImmutableList.copyOf((Collection)fargs));
                modified = true;
                continue;
            }
            if (this.isAlias(args[i])) {
                Operation operation = (Operation)args[i];
                this.aliases.put((Object)operation, (Object)operation.getArg(1).toString());
                continue;
            }
            if (this.isAllExpression(args[i])) continue;
            String alias = "col__" + (i + 1);
            this.aliases.put((Object)args[i], (Object)alias);
            args[i] = ExpressionUtils.as((Expression)args[i], (String)alias);
            modified = true;
        }
        if (modified) {
            metadata = metadata.clone();
            metadata.clearProjection();
            for (Expression arg : args) {
                metadata.addProjection(arg);
            }
        }
        super.serialize(metadata, forCountRow);
    }

    public void visitConstant(Object constant) {
        if (constant instanceof Collection) {
            this.append("(");
            boolean first = true;
            for (Object element : (Collection)constant) {
                if (!first) {
                    this.append(", ");
                }
                this.visitConstant(element);
                first = false;
            }
            this.append(")");
        } else if (!this.getConstantToLabel().containsKey(constant)) {
            String constLabel = String.valueOf(this.getConstantToLabel().size() + 1);
            this.getConstantToLabel().put(constant, constLabel);
            this.append("?" + constLabel);
        } else {
            this.append("?" + (String)this.getConstantToLabel().get(constant));
        }
    }

    protected void visitOperation(Class<?> type, Operator<?> operator, List<? extends Expression<?>> args) {
        if (operator == SQLOps.ALL && !RelationalPath.class.isInstance(args.get(0)) && this.wrapEntityProjections) {
            this.append("{");
            super.visitOperation(type, operator, args);
            this.append("}");
        } else {
            super.visitOperation(type, operator, args);
        }
    }
}

