/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.jpa.hibernate;

import com.mysema.commons.lang.CloseableIterator;
import com.mysema.query.DefaultQueryMetadata;
import com.mysema.query.NonUniqueResultException;
import com.mysema.query.QueryException;
import com.mysema.query.QueryMetadata;
import com.mysema.query.QueryModifiers;
import com.mysema.query.SearchResults;
import com.mysema.query.Tuple;
import com.mysema.query.jpa.FactoryExpressionTransformer;
import com.mysema.query.jpa.HQLTemplates;
import com.mysema.query.jpa.JPAQueryBase;
import com.mysema.query.jpa.JPQLSerializer;
import com.mysema.query.jpa.JPQLTemplates;
import com.mysema.query.jpa.ScrollableResultsIterator;
import com.mysema.query.jpa.hibernate.DefaultSessionHolder;
import com.mysema.query.jpa.hibernate.HibernateQuery;
import com.mysema.query.jpa.hibernate.HibernateUtil;
import com.mysema.query.jpa.hibernate.SessionHolder;
import com.mysema.query.jpa.hibernate.StatelessSessionHolder;
import com.mysema.query.types.Expression;
import com.mysema.query.types.FactoryExpression;
import com.mysema.query.types.FactoryExpressionUtils;
import com.mysema.query.types.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.hibernate.FlushMode;
import org.hibernate.LockMode;
import org.hibernate.Query;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.StatelessSession;
import org.hibernate.transform.ResultTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public abstract class AbstractHibernateQuery<Q extends AbstractHibernateQuery<Q>>
extends JPAQueryBase<Q> {
    private static final Logger logger = LoggerFactory.getLogger(HibernateQuery.class);
    @Nullable
    protected Boolean cacheable;
    @Nullable
    protected Boolean readOnly;
    @Nullable
    protected String cacheRegion;
    @Nullable
    protected String comment;
    protected int fetchSize = 0;
    protected final Map<Path<?>, LockMode> lockModes = new HashMap();
    @Nullable
    protected FlushMode flushMode;
    private final SessionHolder session;
    protected int timeout = 0;

    public AbstractHibernateQuery(Session session) {
        this(new DefaultSessionHolder(session), HQLTemplates.DEFAULT, (QueryMetadata)new DefaultQueryMetadata());
    }

    public AbstractHibernateQuery(SessionHolder session, JPQLTemplates patterns, QueryMetadata metadata) {
        super(metadata, patterns);
        this.session = session;
    }

    public long count() {
        QueryModifiers modifiers = this.getMetadata().getModifiers();
        try {
            Query query = this.createQuery(modifiers, true);
            Long rv = (Long)query.uniqueResult();
            if (rv != null) {
                long l = rv;
                return l;
            }
            throw new QueryException("Query returned null");
        }
        finally {
            this.reset();
        }
    }

    public Query createQuery(Expression<?> expr) {
        this.queryMixin.addProjection(expr);
        return this.createQuery(this.getMetadata().getModifiers(), false);
    }

    public Query createQuery(Expression<?> expr1, Expression<?> expr2, Expression<?> ... rest) {
        this.queryMixin.addProjection(expr1);
        this.queryMixin.addProjection(expr2);
        this.queryMixin.addProjection(rest);
        return this.createQuery(this.getMetadata().getModifiers(), false);
    }

    public Query createQuery(Expression<?>[] args) {
        this.queryMixin.addProjection(args);
        return this.createQuery(this.getMetadata().getModifiers(), false);
    }

    private Query createQuery(@Nullable QueryModifiers modifiers, boolean forCount) {
        FactoryExpression proj;
        List projection;
        JPQLSerializer serializer = this.serialize(forCount);
        String queryString = serializer.toString();
        this.logQuery(queryString, serializer.getConstantToLabel());
        Query query = this.session.createQuery(queryString);
        HibernateUtil.setConstants(query, serializer.getConstantToLabel(), this.getMetadata().getParams());
        if (this.fetchSize > 0) {
            query.setFetchSize(this.fetchSize);
        }
        if (this.timeout > 0) {
            query.setTimeout(this.timeout);
        }
        if (this.cacheable != null) {
            query.setCacheable(this.cacheable.booleanValue());
        }
        if (this.cacheRegion != null) {
            query.setCacheRegion(this.cacheRegion);
        }
        if (this.comment != null) {
            query.setComment(this.comment);
        }
        if (this.readOnly != null) {
            query.setReadOnly(this.readOnly.booleanValue());
        }
        for (Map.Entry<Path<?>, LockMode> entry : this.lockModes.entrySet()) {
            query.setLockMode(entry.getKey().toString(), entry.getValue());
        }
        if (this.flushMode != null) {
            query.setFlushMode(this.flushMode);
        }
        if (modifiers != null && modifiers.isRestricting()) {
            Integer limit = modifiers.getLimitAsInteger();
            Integer offset = modifiers.getOffsetAsInteger();
            if (limit != null) {
                query.setMaxResults(limit.intValue());
            }
            if (offset != null) {
                query.setFirstResult(offset.intValue());
            }
        }
        if ((projection = this.getMetadata().getProjection()).size() == 1 && !forCount) {
            Expression expr = (Expression)projection.get(0);
            if (expr instanceof FactoryExpression) {
                query.setResultTransformer((ResultTransformer)new FactoryExpressionTransformer((FactoryExpression)projection.get(0)));
            }
        } else if (!forCount && (proj = FactoryExpressionUtils.wrap((List)projection)) != null) {
            query.setResultTransformer((ResultTransformer)new FactoryExpressionTransformer(proj));
        }
        return query;
    }

    public CloseableIterator<Tuple> iterate(Expression<?> ... args) {
        return this.iterate((Expression<RT>)this.queryMixin.createProjection(args));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <RT> CloseableIterator<RT> iterate(Expression<RT> projection) {
        try {
            Query query = this.createQuery(projection);
            ScrollableResults results = query.scroll(ScrollMode.FORWARD_ONLY);
            ScrollableResultsIterator scrollableResultsIterator = new ScrollableResultsIterator(results);
            return scrollableResultsIterator;
        }
        finally {
            this.reset();
        }
    }

    public List<Tuple> list(Expression<?> ... args) {
        return this.list((Expression<RT>)this.queryMixin.createProjection(args));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <RT> List<RT> list(Expression<RT> expr) {
        try {
            List list = this.createQuery(expr).list();
            return list;
        }
        finally {
            this.reset();
        }
    }

    public SearchResults<Tuple> listResults(Expression<?> ... args) {
        return this.listResults((Expression<RT>)this.queryMixin.createProjection(args));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <RT> SearchResults<RT> listResults(Expression<RT> expr) {
        try {
            this.queryMixin.addProjection(expr);
            Query countQuery = this.createQuery(null, true);
            long total = (Long)countQuery.uniqueResult();
            if (total > 0L) {
                QueryModifiers modifiers = this.getMetadata().getModifiers();
                Query query = this.createQuery(modifiers, false);
                List list = query.list();
                SearchResults searchResults = new SearchResults(list, modifiers, total);
                return searchResults;
            }
            SearchResults searchResults = SearchResults.emptyResults();
            return searchResults;
        }
        finally {
            this.reset();
        }
    }

    protected void logQuery(String queryString, Map<Object, String> parameters) {
        String normalizedQuery = queryString.replace('\n', ' ');
        MDC.put((String)"querydsl.query", (String)normalizedQuery);
        MDC.put((String)"querydsl.parameters", (String)String.valueOf(parameters));
        if (logger.isDebugEnabled()) {
            logger.debug(normalizedQuery);
        }
    }

    protected void cleanupMDC() {
        MDC.remove((String)"querydsl.query");
        MDC.remove((String)"querydsl.parameters");
    }

    @Override
    protected void reset() {
        super.reset();
        this.cleanupMDC();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScrollableResults scroll(ScrollMode mode, Expression<?> expr) {
        try {
            ScrollableResults scrollableResults = this.createQuery(expr).scroll(mode);
            return scrollableResults;
        }
        finally {
            this.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScrollableResults scroll(ScrollMode mode, Expression<?> ... args) {
        try {
            ScrollableResults scrollableResults = this.createQuery(args).scroll(mode);
            return scrollableResults;
        }
        finally {
            this.reset();
        }
    }

    public Q setCacheable(boolean cacheable) {
        this.cacheable = cacheable;
        return (Q)this;
    }

    public Q setCacheRegion(String cacheRegion) {
        this.cacheRegion = cacheRegion;
        return (Q)this;
    }

    public Q setComment(String comment) {
        this.comment = comment;
        return (Q)this;
    }

    public Q setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
        return (Q)this;
    }

    public Q setLockMode(Path<?> path, LockMode lockMode) {
        this.lockModes.put(path, lockMode);
        return (Q)this;
    }

    public Q setFlushMode(FlushMode flushMode) {
        this.flushMode = flushMode;
        return (Q)this;
    }

    public Q setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        return (Q)this;
    }

    public Q setTimeout(int timeout) {
        this.timeout = timeout;
        return (Q)this;
    }

    @Override
    public Tuple uniqueResult(Expression<?> ... args) {
        return (Tuple)this.uniqueResult((Expression<RT>)this.queryMixin.createProjection(args));
    }

    public <RT> RT uniqueResult(Expression<RT> expr) {
        this.queryMixin.addProjection(expr);
        return (RT)this.uniqueResult();
    }

    private Object uniqueResult() {
        try {
            QueryModifiers modifiers = this.getMetadata().getModifiers();
            Query query = this.createQuery(modifiers, false);
            try {
                Object object = query.uniqueResult();
                return object;
            }
            catch (org.hibernate.NonUniqueResultException e) {
                throw new NonUniqueResultException();
            }
        }
        finally {
            this.reset();
        }
    }

    @Override
    protected JPQLSerializer createSerializer() {
        return new JPQLSerializer(this.getTemplates());
    }

    protected void clone(Q query) {
        this.cacheable = ((AbstractHibernateQuery)query).cacheable;
        this.cacheRegion = ((AbstractHibernateQuery)query).cacheRegion;
        this.fetchSize = ((AbstractHibernateQuery)query).fetchSize;
        this.flushMode = ((AbstractHibernateQuery)query).flushMode;
        this.lockModes.putAll(((AbstractHibernateQuery)query).lockModes);
        this.readOnly = ((AbstractHibernateQuery)query).readOnly;
        this.timeout = ((AbstractHibernateQuery)query).timeout;
    }

    protected abstract Q clone(SessionHolder var1);

    public Q clone(Session session) {
        return this.clone(new DefaultSessionHolder(session));
    }

    public Q clone(StatelessSession session) {
        return this.clone(new StatelessSessionHolder(session));
    }

    @Override
    public Q clone() {
        return this.clone(this.session);
    }
}

