/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.jpa;

import com.mysema.commons.lang.CloseableIterator;
import com.mysema.commons.lang.IteratorAdapter;
import com.mysema.query.jpa.FactoryExpressionTransformer;
import com.mysema.query.jpa.QueryHandler;
import com.mysema.query.jpa.ScrollableResultsIterator;
import com.mysema.query.jpa.TransformingIterator;
import com.mysema.query.types.FactoryExpression;
import java.util.Iterator;
import javax.persistence.Query;
import org.hibernate.SQLQuery;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.jpa.HibernateQuery;
import org.hibernate.transform.ResultTransformer;

public class HibernateHandler
implements QueryHandler {
    @Override
    public void addEntity(Query query, String alias, Class<?> type) {
        org.hibernate.Query hibernateQuery;
        if (query instanceof HibernateQuery && (hibernateQuery = ((HibernateQuery)query).getHibernateQuery()) instanceof SQLQuery) {
            ((SQLQuery)hibernateQuery).addEntity(alias, type);
        }
    }

    @Override
    public void addScalar(Query query, String alias, Class<?> type) {
        org.hibernate.Query hibernateQuery;
        if (query instanceof HibernateQuery && (hibernateQuery = ((HibernateQuery)query).getHibernateQuery()) instanceof SQLQuery) {
            ((SQLQuery)hibernateQuery).addScalar(alias);
        }
    }

    @Override
    public boolean createNativeQueryTyped() {
        return false;
    }

    @Override
    public <T> CloseableIterator<T> iterate(Query query, FactoryExpression<?> projection) {
        if (query instanceof HibernateQuery) {
            HibernateQuery hQuery = (HibernateQuery)query;
            ScrollableResults results = hQuery.getHibernateQuery().scroll(ScrollMode.FORWARD_ONLY);
            Object iterator = new ScrollableResultsIterator(results);
            if (projection != null) {
                iterator = new TransformingIterator(iterator, projection);
            }
            return iterator;
        }
        Iterator iterator = query.getResultList().iterator();
        if (projection != null) {
            return new TransformingIterator(iterator, projection);
        }
        return new IteratorAdapter(iterator);
    }

    @Override
    public boolean transform(Query query, FactoryExpression<?> projection) {
        if (query instanceof HibernateQuery) {
            FactoryExpressionTransformer transformer = new FactoryExpressionTransformer(projection);
            ((HibernateQuery)query).getHibernateQuery().setResultTransformer((ResultTransformer)transformer);
            return true;
        }
        return false;
    }

    @Override
    public boolean wrapEntityProjections() {
        return true;
    }
}

