/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.jpa;

import com.google.common.collect.Maps;
import com.mysema.query.JoinType;
import com.mysema.query.QueryMetadata;
import com.mysema.query.jpa.JPQLOps;
import com.mysema.query.support.Expressions;
import com.mysema.query.support.ReplaceVisitor;
import com.mysema.query.types.Expression;
import com.mysema.query.types.ExpressionUtils;
import com.mysema.query.types.ParametrizedExpression;
import com.mysema.query.types.Path;
import com.mysema.query.types.PathImpl;
import com.mysema.query.types.PathMetadata;
import com.mysema.query.types.PathType;
import java.util.Map;
import javax.annotation.Nullable;

class JPAMapAccessVisitor
extends ReplaceVisitor {
    private final QueryMetadata metadata;
    private final Map<Path<?>, Path<?>> replacements = Maps.newHashMap();

    public JPAMapAccessVisitor(QueryMetadata metadata) {
        this.metadata = metadata;
    }

    public Expression<?> visit(Path<?> expr, @Nullable Void context) {
        PathMetadata pathMetadata = (expr = (Path)super.visit(expr, null)).getMetadata();
        if (pathMetadata.getPathType() == PathType.MAPVALUE || pathMetadata.getPathType() == PathType.MAPVALUE_CONSTANT) {
            PathImpl replacement = this.replacements.get(expr);
            if (replacement == null) {
                Path parent = pathMetadata.getParent();
                ParametrizedExpression parExpr = (ParametrizedExpression)parent;
                replacement = new PathImpl(parExpr.getParameter(1), ExpressionUtils.createRootVariable((Path)parent));
                this.metadata.addJoin(JoinType.JOIN, ExpressionUtils.as((Expression)parent, (Path)replacement));
                this.metadata.addJoinCondition(ExpressionUtils.eq((Expression)Expressions.operation((Class)parExpr.getParameter(0), JPQLOps.KEY, (Expression[])new Expression[]{replacement}), (Expression)ExpressionUtils.toExpression((Object)pathMetadata.getElement())));
                this.replacements.put((Path<?>)expr, (Path<?>)replacement);
            }
            return replacement;
        }
        return super.visit(expr, context);
    }
}

