/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.lucene;

import com.mysema.query.lucene.QueryElement;
import com.mysema.query.types.Path;
import com.mysema.query.types.expr.BooleanExpression;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.Query;

public final class LuceneExpressions {
    public static BooleanExpression fuzzyLike(Path<String> path, String value) {
        Term term = new Term(path.getMetadata().getName(), value);
        return new QueryElement((Query)new FuzzyQuery(term));
    }

    public static BooleanExpression fuzzyLike(Path<String> path, String value, float minimumSimilarity) {
        Term term = new Term(path.getMetadata().getName(), value);
        return new QueryElement((Query)new FuzzyQuery(term, minimumSimilarity));
    }

    public static BooleanExpression fuzzyLike(Path<String> path, String value, float minimumSimilarity, int prefixLength) {
        Term term = new Term(path.getMetadata().getName(), value);
        return new QueryElement((Query)new FuzzyQuery(term, minimumSimilarity, prefixLength));
    }

    private LuceneExpressions() {
    }
}

